/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class NarrowedInputStream
extends InputStream {
    private PushbackInputStream push;
    private byte[] start;
    private byte[] stop;
    private boolean beforeStart = true;
    private boolean afterEnd = false;
    private boolean markStart = false;
    private int markLimit;
    private byte[] comprStart;
    private byte[] comprEnd;

    public NarrowedInputStream(InputStream inputStream, byte[] byArray, byte[] byArray2) {
        this.push = new PushbackInputStream(new NoisyStream(inputStream), Math.max(byArray == null ? 0 : byArray.length, byArray2 == null ? 0 : byArray2.length));
        this.start = byArray;
        this.stop = byArray2;
        if (byArray != null) {
            this.comprStart = new byte[byArray.length];
        }
        if (byArray2 != null) {
            this.comprEnd = new byte[byArray2.length];
        }
    }

    private void readToStart() throws IOException {
        boolean bl = true;
        if (this.start == null) {
            bl = false;
            this.beforeStart = false;
        }
        while (bl) {
            int n = this.push.read(this.comprStart);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n == -1) {
                this.afterEnd = true;
                bl = false;
                continue;
            }
            if (this.compareArrays(this.start, this.comprStart)) {
                bl = false;
                this.beforeStart = false;
                continue;
            }
            this.push.unread(this.comprStart, 1, this.comprStart.length - 1);
        }
        if (this.markStart) {
            super.mark(this.markLimit);
        }
    }

    private boolean compareArrays(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int read() throws IOException {
        if (this.beforeStart) {
            this.readToStart();
        }
        if (this.stop == null) {
            return this.push.read();
        }
        if (this.afterEnd) {
            return -1;
        }
        this.push.read(this.comprEnd, 0, this.comprEnd.length);
        if (this.compareArrays(this.stop, this.comprEnd)) {
            this.afterEnd = true;
            return -1;
        }
        this.push.unread(this.comprEnd, 1, this.comprEnd.length - 1);
        return this.comprEnd[0];
    }

    public void mark(int n) {
        if (this.beforeStart) {
            this.markStart = true;
            this.markLimit = n;
        } else {
            super.mark(n);
        }
    }

    class NoisyStream
    extends InputStream {
        InputStream inp;

        public NoisyStream(InputStream inputStream) {
            this.inp = inputStream;
        }

        public int read() throws IOException {
            int n = this.inp.read();
            System.out.print((char)n);
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            int n = this.inp.read(byArray);
            System.out.println("String is " + new String(byArray));
            return n;
        }
    }
}

