/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.analysis.consensus;

import uk.ac.man.bioinf.analysis.consensus.ConsensusCalculator;
import uk.ac.man.bioinf.analysis.consensus.ConsensusSequence;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.alignment.AbstractGappedSequence;
import uk.ac.man.bioinf.sequence.alignment.EmptyGappedSequence;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEvent;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListener;
import uk.ac.man.bioinf.sequence.event.SequenceEvent;
import uk.ac.man.bioinf.sequence.event.SequenceEventType;
import uk.ac.man.bioinf.sequence.event.SequenceListener;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceEvent;
import uk.ac.man.bioinf.sequence.event.VetoableSequenceListener;
import uk.ac.man.bioinf.sequence.identifier.Identifier;

public class DefaultConsensusSequence
extends AbstractGappedSequence
implements ConsensusSequence,
AlignmentListener,
SequenceListener {
    private GappedSequence currentConsensus = EmptyGappedSequence.getInstance();
    private ConsensusCalculator calculator;
    private VetoableSequenceListener seqListener;

    public DefaultConsensusSequence(ConsensusCalculator consensusCalculator) {
        super(consensusCalculator.getSequenceAlignment().getSequenceType());
        this.calculator = consensusCalculator;
        this.installAlignmentListeners(consensusCalculator);
        this.installVetoListeners();
        this.validate();
    }

    protected void installVetoListeners() {
        this.seqListener = new VetoableSequenceListener(){

            public void changeOccurred(SequenceEvent sequenceEvent) {
            }

            public void vetoableChangeOccurred(VetoableSequenceEvent vetoableSequenceEvent) throws SequenceVetoException {
                throw new SequenceVetoException("Consensus sequences can't be changed except by themselves", vetoableSequenceEvent);
            }
        };
        this.addVetoableSequenceListener(this.seqListener);
    }

    protected void installAlignmentListeners(ConsensusCalculator consensusCalculator) {
        consensusCalculator.getSequenceAlignment().addSequenceListener(this);
        consensusCalculator.getSequenceAlignment().addAlignmentListener(this);
    }

    protected void uninstallAlignmentListners(ConsensusCalculator consensusCalculator) {
        consensusCalculator.getSequenceAlignment().removeSequenceListener(this);
        consensusCalculator.getSequenceAlignment().removeAlignmentListener(this);
    }

    protected void validate() {
        this.calcConsensus();
        this.fireChangeEvent();
    }

    protected void fireChangeEvent() {
        this.fireSequenceEvent(new SequenceEvent(this, 1, this.getGappedLength(), SequenceEventType.UNSPECIFIED));
    }

    protected void calcConsensus() {
        this.currentConsensus.removeVetoableSequenceListener(this.seqListener);
        this.currentConsensus = this.calculator.getCurrentConsensus();
        this.currentConsensus.addVetoableSequenceListener(this.seqListener);
    }

    public void changeOccurred(SequenceEvent sequenceEvent) {
        this.validate();
    }

    public void changeOccurred(AlignmentEvent alignmentEvent) {
        this.validate();
    }

    public Element getElementAt(int n) {
        return this.currentConsensus.getElementAt(n);
    }

    public Element getGappedElementAt(int n) {
        return this.currentConsensus.getGappedElementAt(n);
    }

    public int getGappedLength() {
        return this.currentConsensus.getGappedLength();
    }

    public int getGappedPositionOf(int n) {
        return this.currentConsensus.getGappedPositionOf(n);
    }

    public Element[] getGappedSequenceAsElements() {
        return this.currentConsensus.getGappedSequenceAsElements();
    }

    public GappedSequence getGappedSubSequence(int n, int n2) {
        return this.currentConsensus.getGappedSubSequence(n, n2);
    }

    public int getUngappedPositionOf(int n) {
        return this.currentConsensus.getUngappedPositionOf(n);
    }

    public int getLength() {
        return this.currentConsensus.getLength();
    }

    public Element[] getSequenceAsElements() {
        return this.currentConsensus.getSequenceAsElements();
    }

    public Identifier getIdentifier() {
        return this.currentConsensus.getIdentifier();
    }

    public void setConsensusCalculator(ConsensusCalculator consensusCalculator) {
        this.calculator = consensusCalculator;
        this.validate();
    }

    public ConsensusCalculator getConsensusCalculator() {
        return this.calculator;
    }

    public void deleteGapAtQuietly(int n) {
    }

    public void insertGapAtQuietly(int n) {
    }

    public void destroy() {
        this.uninstallAlignmentListners(this.calculator);
        this.calculator = null;
        this.currentConsensus = EmptyGappedSequence.getInstance();
    }
}

