/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.xml.merge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SortDocument {
    private static final SortPredicate[] predicates = new SortPredicate[]{new NameAttrPredicate("property", "file"), new NamePredicate("property"), new MultiNamePredicate(new String[]{"patternset", "fileset", "path"}), new NamePredicate("taskdef"), new NamePredicate("target")};
    private List[] elementLists = new List[predicates.length];

    public Document sortDocument(Document document) {
        Element projectNode = document.getDocumentElement();
        NodeList list = projectNode.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node item = list.item(i);
            if (item.getNodeType() == 1) {
                this.sortNode(item, projectNode);
            }
            ++i;
        }
        this.refillNodes(projectNode);
        return document;
    }

    protected void sortNode(Node item, Node projectNode) {
        int i = 0;
        while (i < predicates.length) {
            if (predicates[i].accept((Element)item)) {
                this.elementLists[i].add(item);
                return;
            }
            ++i;
        }
    }

    protected void refillNodes(Node projectNode) {
        int i = 0;
        while (i < predicates.length) {
            Iterator iter = this.elementLists[i].iterator();
            while (iter.hasNext()) {
                projectNode.appendChild((Node)iter.next());
            }
            ++i;
        }
    }

    public SortDocument() {
        int i = 0;
        while (i < this.elementLists.length) {
            this.elementLists[i] = new ArrayList();
            ++i;
        }
    }

    public static class NameAttrPredicate
    implements SortPredicate {
        private String name;
        private String attr;

        public boolean accept(Element element) {
            boolean bl = false;
            if (element.getTagName().equals(this.name) && element.getAttributeNode(this.attr) != null) {
                bl = true;
            }
            return bl;
        }

        public NameAttrPredicate(String name, String attr) {
            this.name = name;
            this.attr = attr;
        }
    }

    public static class MultiNamePredicate
    implements SortPredicate {
        private String[] names;

        public boolean accept(Element element) {
            int i = 0;
            while (i < this.names.length) {
                if (element.getTagName().equals(this.names[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public MultiNamePredicate(String[] names) {
            this.names = names;
        }
    }

    public static class NamePredicate
    implements SortPredicate {
        private String name;

        public boolean accept(Element element) {
            return element.getTagName().equals(this.name);
        }

        public NamePredicate(String name) {
            this.name = name;
        }
    }

    public static interface SortPredicate {
        public boolean accept(Element var1);
    }
}

