/*
 * Copyright (C) 2003 The University of Manchester 
 *
 * Modifications to the initial code base are copyright of their
 * respective authors, or their employers as appropriate.  Authorship
 * of the modifications may be determined from the ChangeLog placed at
 * the end of this file.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 *
 ****************************************************************
 * Source code information
 * -----------------------
 * Filename           $RCSfile: VarAdaptableElement.java,v $
 * Revision           $Revision: 1.1 $
 * Release status     $State: Exp $
 * Last modified on   $Date: 2004/01/06 18:32:01 $
 *               by   $Author: lordp $
 ****************************************************************/
package uk.ac.man.cs.img.xml.merge;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;



/**
 * VarAdaptableElement.java
 *
 *
 * Created: Fri Dec 12 17:05:27 2003
 *
 * @author <a href="mailto:p.lord@russet.org.uk">Phillip Lord</a>
 * @version 1.0
 */
public class VarAdaptableElement implements AdaptableElement 
{
    
    public boolean debug = false;
    public String attributeContainingSuper;
    
    public VarAdaptableElement( String attributeContainingSuper ) 
    {
        this.attributeContainingSuper = attributeContainingSuper;
    } // VarAdaptableElement constructor
    
    private Pattern pattern = Pattern.compile
        ( "\\$\\{super\\}" );
    
    public Element adaptChild( Element parent, Element child )
    {
        
        if( debug ) System.out.println( "adapting child with " + attributeContainingSuper );
        
        if( debug ){
            System.out.println( "Parent " );
            Debug.debug( parent );
            System.out.println( "Child " );
            Debug.debug( child );
        }
        
            
        Attr childAtt = child.getAttributeNode( attributeContainingSuper );
        
        // null check. The attribute which protentially contains null
        // might not actually occur.
        if( childAtt == null ){
            return child;
        }
        
        String childAttVal =  childAtt.getValue();
        
        Matcher matcher = pattern.matcher( childAttVal );
        
        if( matcher.find() ){
            String parentAtt = parent.getAttribute( attributeContainingSuper );
            
            // the regexp replace methods do a perl-like variable
            // interpolation with $ on match groups. So all they have
            // to be escaped. Yeech. 
            parentAtt = replaceDollars( parentAtt );
            
            // think this should be replace first...
            String replaced = matcher.replaceAll( parentAtt );
            childAtt.setValue( replaced );
        }
        
        if( debug ){
            System.out.println( "Output " );
            Debug.debug( child );
        }
        
        return child;
    }

    public static String replaceDollars( String string )
    {
        StringBuffer buffer = new StringBuffer();
        
        for( int i = 0; i < string.length(); i++ ){
            if( string.charAt( i ) == '$'  ){
                buffer.append( "\\$" );
            }
            else{
                buffer.append( string.charAt( i ) );
            }
        }
        return buffer.toString();
    }

} // VarAdaptableElement
