/*
 * Copyright (C) 2003 The University of Manchester 
 *
 * Modifications to the initial code base are copyright of their
 * respective authors, or their employers as appropriate.  Authorship
 * of the modifications may be determined from the ChangeLog placed at
 * the end of this file.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 *
 ****************************************************************
 * Source code information
 * -----------------------
 * Filename           $RCSfile: TagAndVarAdaptableElement.java,v $
 * Revision           $Revision: 1.1 $
 * Release status     $State: Exp $
 * Last modified on   $Date: 2004/01/06 18:32:01 $
 *               by   $Author: lordp $
 ****************************************************************/
package uk.ac.man.cs.img.xml.merge;

import org.w3c.dom.Element;




/**
 * TagAndVarAdaptableElement.java
 *
 *
 * Created: Fri Dec 12 17:01:48 2003
 *
 * @author <a href="mailto:p.lord@russet.org.uk">Phillip Lord</a>
 * @version 1.0
 */
public class TagAndVarAdaptableElement implements AdaptableElement
{
    private String superContainingAttr;
    private VarAdaptableElement varAdapt;
    private TagAdaptableElement tagAdapt;
    
    public TagAndVarAdaptableElement( String superContainingAttr )
    {
        this.superContainingAttr = superContainingAttr;
        varAdapt = new VarAdaptableElement( superContainingAttr );
        tagAdapt = new TagAdaptableElement();
    }
    
    public Element adaptChild( Element parent, Element child )
    {
        
        Element retn = tagAdapt.adaptChild( parent, child );
        retn = varAdapt.adaptChild( parent, retn );
        return retn;
    }
} // TagAndVarAdaptableElement

