package uk.ac.man.cs.img.xml.merge;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;



public class Debug
{


    public static void debug( Document node )
    {
        try{
            
            // Output the document
            OutputFormat    format  = new OutputFormat( node, null, true );
            StringWriter  stringOut = new StringWriter();
            XMLSerializer    serial = new XMLSerializer( stringOut, format );
            serial.asDOMSerializer();
            serial.serialize( node.getDocumentElement() );
            System.out.println( stringOut.toString() );
        }
        catch( Throwable t ){
            t.printStackTrace();
        }
    } 

    public static void debug( Node element )
    {
        try{
            // set up some parsers for later use
            DocumentBuilderFactory builderFactory = new org.apache.xerces.jaxp.DocumentBuilderFactoryImpl();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            
            Document document = builder.newDocument();
            
            Node imported = document.importNode( element, true );
            document.appendChild( imported );
            
            debug( document );
        }
        catch( Throwable t ){
            t.printStackTrace();
        }
    }

    
}
