/*
 * Copyright (C) 2003 The University of Manchester 
 *
 * Modifications to the initial code base are copyright of their
 * respective authors, or their employers as appropriate.  Authorship
 * of the modifications may be determined from the ChangeLog placed at
 * the end of this file.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 *
 ****************************************************************
 * Source code information
 * -----------------------
 * Filename           $RCSfile: NonEmptyManifest.java,v $
 * Revision           $Revision: 1.1 $
 * Release status     $State: Exp $
 * Last modified on   $Date: 2003/11/24 16:50:04 $
 *               by   $Author: lordp $
 ****************************************************************/

package uk.ac.man.cs.img.anttasks; // Generated package name

import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.ManifestTask;
import java.util.Enumeration;


/**
 * NonEmptyManifest.java
 *
 * This task has been created to help with antmerge. The point of it,
 * is to enable a Manifest task where if an attribute is specified,
 * with no value (or rather a empty string parameter) it will just be
 * ignored. 
 *
 * Created: Wed Oct  1 21:30:43 2003
 *
 * @author Phillip Lord
 * @version $Id: NonEmptyManifest.java,v 1.1 2003/11/24 16:50:04 lordp Exp $
 */

public class NonEmptyManifest extends ManifestTask 
{
    private static final int MSG_VERBOSE = Project.MSG_VERBOSE;
    public void addConfiguredAttribute( Manifest.Attribute attribute )
        throws ManifestException
    {
        if( !attributeEmptyP( attribute ) ){
            super.addConfiguredAttribute( attribute );
        }
        else{
            log( "Discarding attribute " + attribute.getName(), MSG_VERBOSE );
        }
    }
    
    public void addConfiguredSection( Manifest.Section section )
    {
        try{
            
        for( Enumeration enum = section.getAttributeKeys();
             enum.hasMoreElements(); ){
            Manifest.Attribute attribute = section.getAttribute
                ( (String)enum.nextElement() );
            if( attributeEmptyP( attribute ) ){
                section.removeAttribute( attribute.getKey() );
            
                log( "Discarding attribute " + attribute.getName() + 
                     " from section" + section.getName(),
                     MSG_VERBOSE );
            }
        }
        
        if( !sectionEmptyP( section ) ){
            super.addConfiguredSection( section );
        }
        else{
            log( "Discarding section as its empty " + section.getName(),
                 MSG_VERBOSE );
        }
        }
        catch( Throwable t ){
            t.printStackTrace();
        }
        
               
        
    }
    
    private boolean sectionEmptyP( Manifest.Section section )
    {
        int i = 0;

        for( Enumeration enum = section.getAttributeKeys();
             enum.hasMoreElements(); ){
            enum.nextElement();
            i++;
        }
        
        return (i == 0);
    }
    
    private boolean attributeEmptyP( Manifest.Attribute attribute )
    {
        return attribute.getValue().equals( "" );
    }
    
    
} // NonEmptyManifest



/*
 * ChangeLog
 * $Log: NonEmptyManifest.java,v $
 * Revision 1.1  2003/11/24 16:50:04  lordp
 * Initial Checkin
 *
 */
