package uk.ac.man.cs.img.anttasks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;


/**
 * NetbeansClasspath.java
 *
 *
 * Created: Wed Sep 24 15:15:30 2003
 *
 * @author <a href="mailto:p.lord@russet.org.uk">Phillip Lord</a>
 * @version 1.0
 */
public class NetbeansClasspath extends Task
{
    private String dependencies;
    public void setDependencies( String dependencies )
    {
        this.dependencies = dependencies;
    }
    
    private File manifest;
    public void setManifest( File manifest )
    {
        this.manifest = manifest;
    }
    
    private String directoryPrefix;
    public void setDirectoryPrefix( String directoryPrefix )
    {
        this.directoryPrefix = directoryPrefix;
    }
    
    public void execute()
    {
        StringTokenizer token = new StringTokenizer( dependencies, "," );
            
        StringBuffer output = new StringBuffer();
        
        output.append( "Class-Path: " );
        
        while( token.hasMoreTokens()){
            output.append( directoryPrefix );
            output.append( "/" );
            output.append( token.nextToken() );
            output.append( " " );
        }
        
        
        try{
            FileWriter writer = new FileWriter( manifest, true );
            writer.write( output.toString() );
            writer.close();
        }
        catch( IOException ioe ){
            throw new BuildException( ioe );
        }
    }
    
} // NetbeansClasspath
