/*
 * Copyright (C) 2003 The University of Manchester 
 *
 * Modifications to the initial code base are copyright of their
 * respective authors, or their employers as appropriate.  Authorship
 * of the modifications may be determined from the ChangeLog placed at
 * the end of this file.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 *
 ****************************************************************
 * Source code information
 * -----------------------
 * Filename           $RCSfile: ExtClasspath.java,v $
 * Revision           $Revision: 1.1 $
 * Release status     $State: Exp $
 * Last modified on   $Date: 2003/11/24 16:50:04 $
 *               by   $Author: lordp $
 ****************************************************************/

package uk.ac.man.cs.img.anttasks; // Generated package name

import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;




/**
 * ExtClasspath.java
 *
 *
 * Created: Wed Oct  1 22:21:41 2003
 *
 * @author Phillip Lord
 * @version $Id: ExtClasspath.java,v 1.1 2003/11/24 16:50:04 lordp Exp $
 */

public class ExtClasspath extends Task 
{
    private String name;
    public void setName( String name )
    {
        this.name = name;
    }
    
    private String jarfiles;
    public void setJarFiles( String jarfiles )
    {
        this.jarfiles = jarfiles;
    }
    
    public void execute() throws BuildException
    {
        if( jarfiles == null || name == null ){
            throw new BuildException( "Both name and jarfiles attribute must be set" );
        }
        
        Project project = getProject();
        if( project.getProperty( name ) != null ||
            project.getUserProperty( name ) != null ){
            throw new BuildException( "Property " + name + " already exists" );
        }
        
        StringBuffer retn = new StringBuffer();
        StringTokenizer token = new StringTokenizer( jarfiles, "," );
        
        while( token.hasMoreTokens() ){
            retn.append( "ext/" );
            retn.append( token.nextToken() );
            retn.append( " " );
        }
        
        project.setProperty( name, retn.toString() );
    }
    
    
} // ExtClasspath



/*
 * ChangeLog
 * $Log: ExtClasspath.java,v $
 * Revision 1.1  2003/11/24 16:50:04  lordp
 * Initial Checkin
 *
 */
