/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.anttasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;

public class CheckDependencies
extends Task {
    private File dirOne;
    private File dirTwo;
    private String[] includedPatterns;

    public void setDirOne(File dirOne) {
        this.dirOne = dirOne;
    }

    public void setDirTwo(File dirTwo) {
        this.dirTwo = dirTwo;
    }

    public void setPatternSetRef(Reference reference) {
        PatternSet patternSet = (PatternSet)reference.getReferencedObject(this.getProject());
        this.includedPatterns = patternSet.getIncludePatterns(this.getProject());
    }

    public void execute() {
        this.log("dir one is " + this.dirOne.getAbsolutePath() + " dir two is " + this.dirTwo.getAbsolutePath(), 4);
        int i = 0;
        while (i < this.includedPatterns.length) {
            if (!this.checkDependencyExists(this.includedPatterns[i])) {
                throw new BuildException("Unable to find dependency " + this.includedPatterns[i]);
            }
            ++i;
        }
    }

    private final boolean checkDependencyExists(String file) {
        if (file.equals("YouHaveNothingToLooseButYourChains")) {
            return true;
        }
        File possOne = new File(this.dirOne, file);
        File possTwo = new File(this.dirTwo, file);
        this.log("Searching for dependency " + file, 4);
        if (possOne.exists()) {
            this.log("Found dependency " + possOne.getAbsolutePath(), 4);
            return true;
        }
        this.log("Failed to find dependency in " + possOne.getAbsolutePath(), 4);
        if (possTwo.exists()) {
            this.log("Found dependency " + possTwo.getAbsolutePath(), 4);
            return true;
        }
        this.log("Failed to find dependency in " + possTwo.getAbsolutePath(), 4);
        return false;
    }
}

