/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.xml.merge;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import uk.ac.man.cs.img.xml.merge.MergeDocuments;
import uk.ac.man.cs.img.xml.merge.SuperTagUniqueAttributeTagPredicate;
import uk.ac.man.cs.img.xml.merge.SuperVarUniqueAttributeTagPredicate;
import uk.ac.man.cs.img.xml.merge.UniqueAttributeTagPredicate;
import uk.ac.man.cs.img.xml.merge.UniqueIDAtttributePredicate;
import uk.ac.man.cs.img.xml.merge.UniquePredicate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AntMerge {
    private static final String defaultProgramName = "antmerge";
    private static final String defaultMergeFile = "build-in.xml";
    private static final String defaultOutputFile = "build.xml";
    private static final String emptyFile = "empty.xml";
    private static final String defaultMainFile = "default.xml";
    private static final UniquePredicate[] predicate = new UniquePredicate[]{UniqueIDAtttributePredicate.prototypeInstance(), new SuperTagUniqueAttributeTagPredicate("target", "name"), new SuperVarUniqueAttributeTagPredicate("property", "name", "value"), new UniqueAttributeTagPredicate("property", "environment"), new UniqueAttributeTagPredicate("taskdef", "name")};
    private String programName;
    private String defaultInstallationDirectory;
    private String defaultUserDirectory;
    private boolean debug;
    private boolean mergeFileEmpty;
    private boolean suppressAntmergeXML;
    private DocumentBuilderFactory builderFactory;
    private DocumentBuilder builder;
    private File installationDirectory;
    private File buildFilesDirectory;
    private File userDirectory;
    private File[] mainFiles;
    private File mergeFile;
    private File outputFile;

    private final void debug(String message) {
        if (this.debug) {
            System.out.println("Debug: " + message);
        }
    }

    public void help() {
        System.out.println("Usage: " + this.programName + "[OPTION]...");
        System.out.println("  or:  " + this.programName + "[OPTION]... [MAIN_FILE]...");
        System.out.println("Merge the ant build-file MAIN_FILE with the another.");
        System.out.println("The merging process provides something like inheritance for ant build files");
        System.out.println("Unless explicitly set a FILE with the name build-in.xml is used as the merge file");
        System.out.println("A number of default MAIN_FILES are supplied, and additionally the directory ");
        System.out.println("\"" + this.defaultUserDirectory + "\" is searched.");
        System.out.println("The OUTPUT_FILE defaults to build.xml.");
        System.out.println("   -c,  --clean     output a clean build file without merging");
        System.out.println("   -h,  --help      output this message and exit");
        System.out.println("   -i,  --installation_directory   specify the installation directory of the application");
        System.out.println("   -m,  --mainfile  specify MAIN_FILE");
        System.out.println("   -n,  --mergefile specify FILE");
        System.out.println("   -o,  --output    specify OUTPUT_FILE");
        System.out.println("   -s,  --no_antmerge suppress addition of antmerge main file");
        System.out.println("   -v,  --version   display version information and exit");
        System.out.println();
        System.out.println("The most recent version is available from <http://www.russet.org.uk>");
    }

    public void version() {
        System.out.println(defaultProgramName + this.getVersion());
        System.out.println("Written by Phillip Lord (p.lord@russet.org.uk).");
        System.out.println();
        System.out.println("Copyright (C) 2002 Phillip Lord, The Victoria University of Manchester");
        System.out.println("This is free software; see the source for copying conditions. There is NO");
        System.out.println("warranty: not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
    }

    private final File fileExistsTest(String name) {
        return this.fileExistsTest(System.getProperty("user.dir"), name);
    }

    private final File fileExistsTest(String directory, String name) {
        return this.fileExistsTest(new File(directory), name);
    }

    private final File fileExistsTest(File directory, String name) {
        File file = new File(directory, name);
        this.debug("Testing for file existence " + file.getAbsolutePath());
        if (file.exists()) {
            return file;
        }
        this.debug("File not found");
        return null;
    }

    public void setInstallationDirectory(String installation) {
        this.setInstallationDirectory(new File(installation));
    }

    public void setInstallationDirectory(File installationDirectory) {
        this.debug("Setting installation directory: " + installationDirectory.getAbsolutePath());
        this.installationDirectory = installationDirectory;
        this.buildFilesDirectory = new File(installationDirectory, "etc");
    }

    public void setUserDirectory(String user) {
        this.setUserDirectory(new File(user));
    }

    public void setUserDirectory(File userDirectory) {
        this.debug("Setting user directory: " + userDirectory.getAbsolutePath());
        this.userDirectory = userDirectory;
    }

    private final String[] splitMainFiles(String mainFiles) {
        this.debug("Spliting mainfile " + mainFiles + " into tokens");
        StringTokenizer tokenizer = new StringTokenizer(mainFiles, "+,");
        String[] retn = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            retn[i++] = tokenizer.nextToken();
        }
        return retn;
    }

    public void setMainFile(String mainFile) throws FileNotFoundException {
        this.debug("Setting main file " + mainFile);
        this.setMainFiles(this.splitMainFiles(mainFile));
    }

    public void setMainFile(File mainFile) {
        this.debug("Setting main file:" + mainFile.getAbsolutePath());
        this.mainFiles = new File[1];
        this.mainFiles[0] = mainFile;
    }

    public void setMainFiles(String[] mainFilesString) throws FileNotFoundException {
        this.mainFiles = new File[mainFilesString.length];
        int i = 0;
        while (i < this.mainFiles.length) {
            this.mainFiles[i] = this.resolveMainFile(mainFilesString[i]);
            ++i;
        }
    }

    public void setMainFiles(File[] mainFiles) {
        this.mainFiles = mainFiles;
    }

    protected File resolveMainFile(String file) throws FileNotFoundException {
        if (!file.endsWith(".xml")) {
            file = file + ".xml";
        }
        this.debug("Resolve main file " + file);
        this.debug("Searching for main file: " + file);
        this.debug("Searching for main file: in cwd");
        File mainFile = this.fileExistsTest(file);
        if (mainFile != null) {
            return mainFile;
        }
        this.debug("Searching for main file: in user directory");
        mainFile = this.fileExistsTest(this.userDirectory, file);
        if (mainFile != null) {
            return mainFile;
        }
        this.debug("Searching for main file: in installation build files directory");
        mainFile = this.fileExistsTest(this.buildFilesDirectory, file);
        if (mainFile != null) {
            return mainFile;
        }
        this.debug("Main file not found");
        throw new FileNotFoundException("The main file " + file + " was not found");
    }

    public void setMergeFile(String mergeFile) throws FileNotFoundException {
        this.debug("Setting merge file: " + mergeFile);
        File file = this.fileExistsTest(mergeFile);
        if (file != null) {
            this.setMergeFile(new File(mergeFile));
            return;
        }
        file = this.fileExistsTest(mergeFile + ".xml");
        if (file != null) {
            this.setMergeFile(new File(mergeFile));
            return;
        }
        throw new FileNotFoundException("The merge file " + mergeFile + " was not found");
    }

    public void setMergeFile(File mergeFile) {
        this.debug("Setting merge file " + mergeFile.getAbsolutePath());
        this.mergeFile = mergeFile;
    }

    public void setOutputFile(String file) throws FileNotFoundException {
        this.setOutputFile(new File(file));
    }

    public void setOutputFile(File outputFile) {
        this.debug("Setting output file " + outputFile);
        this.outputFile = outputFile;
    }

    public String getVersion() {
        return "-1.0.5";
    }

    public void mergeFiles() throws IOException, ParserConfigurationException, SAXException {
        this.debug("Merging files");
        Document output = this.merge();
        OutputFormat format = new OutputFormat(output, null, true);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        serial.asDOMSerializer();
        serial.serialize(output.getDocumentElement());
        this.debug("Output file generated:- \n" + stringOut.toString());
        this.debug("outputing to file ");
        FileWriter fileWriter = new FileWriter(this.outputFile);
        fileWriter.write(stringOut.toString());
        fileWriter.close();
    }

    public Document merge() throws SAXException, IOException {
        this.debug("Merging");
        this.debug("Parsing file " + this.mainFiles[0]);
        String mainFileNames = "";
        Document documentSoFar = this.builder.parse(this.mainFiles[0]);
        documentSoFar.getDocumentElement().insertBefore(documentSoFar.createComment("Generated from " + this.mainFiles[0].getAbsolutePath()), documentSoFar.getDocumentElement().getFirstChild());
        int i = 0;
        while (i < this.mainFiles.length) {
            documentSoFar = this.merge(documentSoFar, this.mainFiles[i]);
            mainFileNames = mainFileNames + this.mainFiles[i] + ',';
            ++i;
        }
        documentSoFar = this.merge(documentSoFar, this.mergeFile);
        if (!this.suppressAntmergeXML) {
            Element target = documentSoFar.createElement("target");
            target.setAttribute("name", "antmerge.test.main");
            Element condition = documentSoFar.createElement("condition");
            condition.setAttribute("property", "build.main.required");
            target.appendChild(condition);
            Element orCondition = documentSoFar.createElement("or");
            condition.appendChild(orCondition);
            int i2 = 0;
            while (i2 < this.mainFiles.length) {
                orCondition.appendChild(this.generateUpdateTo(documentSoFar, this.mainFiles[i2].getAbsolutePath()));
                ++i2;
            }
            documentSoFar.getDocumentElement().insertBefore(target, documentSoFar.getDocumentElement().getFirstChild());
        }
        documentSoFar.getDocumentElement().insertBefore(documentSoFar.createComment("This file has been auto-generated by the AntMerge tool. Do not edit"), documentSoFar.getDocumentElement().getFirstChild());
        return documentSoFar;
    }

    private final Element generateUpdateTo(Document document, String mainFile) {
        Element not = document.createElement("not");
        Element uptodate = document.createElement("uptodate");
        uptodate.setAttribute("srcfile", mainFile);
        uptodate.setAttribute("targetfile", defaultOutputFile);
        not.appendChild(uptodate);
        return not;
    }

    protected Document merge(Document mainDocument, File mergeFile) throws SAXException, IOException {
        this.debug("Parsing file " + mergeFile);
        Document documentMerge = this.builder.parse(mergeFile);
        Document output = this.merge(mainDocument, documentMerge);
        output.getDocumentElement().insertBefore(output.createComment("Generated from " + mergeFile.getAbsolutePath()), output.getDocumentElement().getFirstChild());
        return output;
    }

    protected Document merge(Document mainDocument, Document mergeDocument) {
        return this.merge(mainDocument, mergeDocument, this.builder.newDocument());
    }

    public Document merge(Document mainDocument, Document mergeDocument, Document output) {
        MergeDocuments merge = new MergeDocuments(predicate);
        merge.merge(mainDocument, mergeDocument, output);
        String projectName = mergeDocument.getDocumentElement().getAttribute("name");
        String projectDefault = mergeDocument.getDocumentElement().getAttribute("default");
        output.getDocumentElement().setAttribute("name", projectName);
        output.getDocumentElement().setAttribute("default", projectDefault);
        return output;
    }

    public static void main(String[] args) throws Throwable {
        AntMerge antMerge = new AntMerge(args);
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.mergeFileEmpty = false;
        this.suppressAntmergeXML = false;
    }

    protected AntMerge(String[] args) throws ParserConfigurationException {
        int c;
        this.this();
        this.defaultInstallationDirectory = System.getProperty("installation.directory") == null ? "." : System.getProperty("installation.directory");
        String installationDirectory = this.defaultInstallationDirectory;
        this.defaultUserDirectory = System.getProperty("user.extra.directory") == null ? "." : System.getProperty("user.extra.directory");
        String userDirectory = this.defaultUserDirectory;
        this.programName = System.getProperty("program.name") == null ? defaultProgramName : System.getProperty("program.name");
        this.builderFactory = new DocumentBuilderFactoryImpl();
        this.builder = this.builderFactory.newDocumentBuilder();
        String mainFile = defaultMainFile;
        String mergeFile = defaultMergeFile;
        String outputFile = defaultOutputFile;
        LongOpt[] options = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118), new LongOpt("installation_directory", 1, null, 105), new LongOpt("user_directory", 1, null, 117), new LongOpt("output", 1, null, 111), new LongOpt("mainfiles", 1, null, 109), new LongOpt("mergefile", 1, null, 110), new LongOpt("clean", 0, null, 99), new LongOpt("debug", 0, null, 100), new LongOpt("no_antmerge", 0, null, 115)};
        Getopt g = new Getopt(this.programName, args, "cdhvi:u:o:m:n:s", options);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 0: 
                case 104: {
                    this.help();
                    System.exit(0);
                    break;
                }
                case 1: 
                case 118: {
                    this.version();
                    System.exit(0);
                    break;
                }
                case 2: 
                case 105: {
                    installationDirectory = g.getOptarg();
                    break;
                }
                case 3: 
                case 117: {
                    userDirectory = g.getOptarg();
                    break;
                }
                case 4: 
                case 111: {
                    outputFile = g.getOptarg();
                    break;
                }
                case 5: 
                case 109: {
                    mainFile = g.getOptarg();
                    break;
                }
                case 6: 
                case 110: {
                    mergeFile = g.getOptarg();
                    break;
                }
                case 7: 
                case 99: {
                    this.mergeFileEmpty = true;
                    break;
                }
                case 8: 
                case 100: {
                    this.debug = true;
                    break;
                }
                case 9: 
                case 115: {
                    this.suppressAntmergeXML = true;
                    break;
                }
            }
        }
        if (mainFile == defaultMainFile && args.length > g.getOptind()) {
            mainFile = args[g.getOptind()];
        }
        try {
            this.setInstallationDirectory(installationDirectory);
            this.setUserDirectory(userDirectory);
            if (this.mergeFileEmpty) {
                this.setMergeFile(new File(this.buildFilesDirectory, emptyFile));
            } else {
                this.setMergeFile(mergeFile);
            }
            if (!this.suppressAntmergeXML) {
                mainFile = "antmerge," + mainFile;
            }
            this.setMainFile(mainFile);
            this.setOutputFile(outputFile);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(this.programName + ": " + fnfe.getMessage());
            System.out.println("Try " + this.programName + " -h for usage");
            System.exit(-1);
        }
        try {
            this.mergeFiles();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
            System.exit(-1);
        }
        catch (ParserConfigurationException pce) {
            System.out.println("There is a serious error. The application is probably broken");
            System.out.println(pce.getMessage());
            System.exit(-2);
        }
        catch (SAXException se) {
            System.out.println(se.getMessage());
            System.exit(-3);
        }
        System.out.println("Generated file " + this.outputFile.getName());
    }
}

