/*
 *  Copyright 2002 Phillip Lord, Victoria University of Manchester
 *
 *  This file is part of myGrid.  Further information, and the
 *  latest version, can be found at http://www.mygrid.info
 *
 *  myGrid is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  myGrid is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with myGrid; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package uk.ac.man.cs.img.xml.merge; 

import org.w3c.dom.Element;


/**
 * UniquePredicate.java
 *
 * Defines a mechanism for calculating a unique identifier from a
 * given DOM element. This is used when merging documents. If two DOM
 * elements are found to have the same unique identifier, then one is
 * used to replace the other in the output.
 *
 * This class operates as a wrapper for the given Element, redefining
 * hashCode, and equals appropriately, to allow storage and rapid
 * retrieval of the Element. 
 *
 * The class also operates as a prototype, allowing generation of a
 * new instance from an existing one. This save the effort of defining
 * factory objects for each UniquePredicate type.
 *
 * Created: Wed Nov 27 21:21:31 2002
 *
 * @author Phillip Lord
 * @version $Id: UniquePredicate.java,v 1.2 2002/12/10 14:30:59 lordp Exp $ 
 */

public interface UniquePredicate 
{
    /**
     * Can we generate a unique identifier for this element?
     */
    public boolean accept( Element element );
    
    /**
     * Generate an instance of this UniquePredicate, wrapping a
     * specific Element. 
     * 
     * @param element
     * @return an <code>UniquePredicate</code> value
     * @throws IllegalArgumentException if element would return false
     * when given to the accept method.
     */
    public UniquePredicate newInstance( Element element );
    
    /**
     * Get the element that this object wraps.
     *
     * @return an <code>Element</code> value
     */
    public Element getElement();
    
    // both of these methods are in object anyway, but I am putting
    // them here to remind me to implement them!
    public int hashCode();

    public boolean equals( Object object );
}// UniquePredicate


/*
 * ChangeLog
 * $Log: UniquePredicate.java,v $
 * Revision 1.2  2002/12/10 14:30:59  lordp
 * Added boilerplate
 *
 * Revision 1.1  2002/12/04 17:19:51  lordp
 * Initial checkin
 * 
 */

