/*
 * Copyright (C) 2003 The University of Manchester 
 *
 * Modifications to the initial code base are copyright of their
 * respective authors, or their employers as appropriate.  Authorship
 * of the modifications may be determined from the ChangeLog placed at
 * the end of this file.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 *
 ****************************************************************
 * Source code information
 * -----------------------
 * Filename           $RCSfile: CheckDependencies.java,v $
 * Revision           $Revision: 1.2 $
 * Release status     $State: Exp $
 * Last modified on   $Date: 2003/09/25 09:46:16 $
 *               by   $Author: lordp $
 ****************************************************************/

package uk.ac.man.cs.img.anttasks; // Generated package name

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;




/**
 * CheckDependencies.java
 *
 * This task is pretty specific to antmerge. It checks that
 * dependencies all exist. These are specified as a pattern set
 * and ant does not normally complain if all possible values in the
 * pattern are not present. 
 *
 * Created: Sun Sep 21 14:02:30 2003
 *
 * @author Phillip Lord
 * @version $Id: CheckDependencies.java,v 1.2 2003/09/25 09:46:16 lordp Exp $
 */

public class CheckDependencies extends Task
{
    private File dirOne, dirTwo;
    
    public void setDirOne( File dirOne )
    {
        this.dirOne = dirOne;
    }
    
    public void setDirTwo( File dirTwo )
    {
        this.dirTwo = dirTwo;
    }
    
    private String[] includedPatterns;
    public void setPatternSetRef( Reference reference )
    {
        PatternSet patternSet =(PatternSet)reference.getReferencedObject
            ( getProject() );
        includedPatterns = patternSet.getIncludePatterns( getProject() );
    }
    
    public void execute()
    {
        log( "dir one is " + dirOne.getAbsolutePath()  + " dir two is " + dirTwo.getAbsolutePath(), 4 );
        for( int i = 0; i < includedPatterns.length; i++ ){
            if( !checkDependencyExists( includedPatterns[ i ] ) ){
                throw new BuildException( "Unable to find dependency "
                                          + includedPatterns[ i ] );
            }
        }
    }
    
    private boolean checkDependencyExists( String file )
    {
        // first of all we need to check for this phrase. It's used in
        // the build files as a hack around an ant bug...an empty
        // includes pattern is taken as meaning include everything
        // rather than nothing. 
        if( file.equals( "YouHaveNothingToLooseButYourChains" ) ){
            return true;
        }
        
        File possOne = new File( dirOne, file );
        File possTwo = new File( dirTwo, file );
        
        log( "Searching for dependency " + file, 4 );
        if( possOne.exists() ){
            log( "Found dependency " + possOne.getAbsolutePath(), 4 );
            return true;
        }
        else{
            log( "Failed to find dependency in " + possOne.getAbsolutePath(), 4 );
        }
        
        
        if( possTwo.exists() ){
            log( "Found dependency " + possTwo.getAbsolutePath(), 4 );
            return true;
        }
        else{
            log( "Failed to find dependency in " + possTwo.getAbsolutePath(), 4 );
        }
        
        // oh dear...
        return false;
    }
    
    
} // CheckDependencies



/*
 * ChangeLog
 * $Log: CheckDependencies.java,v $
 * Revision 1.2  2003/09/25 09:46:16  lordp
 * Added logging
 *
 * Revision 1.1  2003/09/24 12:24:40  lordp
 * Initial checkin
 *
 */
