/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.anttasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class JdeeTask
extends Task {
    private File projectFile;
    private File outFile;
    private StringBuffer retn;
    private String[] jdeGlobalClasspath;
    private String jdeCompileOptionDirectory;
    private File jdeSourcepath;
    private int insertionPoint;
    private StringBuffer project;

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    private final StringBuffer getStringBuffer() {
        if (this.retn == null) {
            this.retn = new StringBuffer();
        }
        this.retn.setLength(0);
        return this.retn;
    }

    private final void closeParensInLisp(StringBuffer buffer) {
        int openParen = 0;
        int closeParen = 0;
        int lastOpenParen = 0;
        while ((lastOpenParen = buffer.indexOf("(", lastOpenParen)) != -1) {
            ++lastOpenParen;
            ++openParen;
        }
        int lastCloseParen = 0;
        while ((lastCloseParen = buffer.indexOf(")", lastCloseParen)) != -1) {
            ++lastCloseParen;
            ++closeParen;
        }
        int parensToAdd = openParen - closeParen;
        while (parensToAdd > 0) {
            buffer.append(")");
            --parensToAdd;
        }
    }

    private final void appendQuotedString(StringBuffer buffer, String string) {
        buffer.append("\"");
        buffer.append(string);
        buffer.append("\" ");
    }

    public void setJdeGlobalClasspathRef(Reference reference) {
        Path path = new Path(this.getProject());
        path.setRefid(reference);
        this.jdeGlobalClasspath = path.list();
    }

    private final String getJdeGlobalClasspathLisp() {
        if (this.jdeGlobalClasspath != null) {
            StringBuffer retn = this.getStringBuffer();
            retn.append(" '(jde-global-classpath (quote (");
            int i = 0;
            while (i < this.jdeGlobalClasspath.length) {
                this.appendQuotedString(retn, this.jdeGlobalClasspath[i]);
                ++i;
            }
            this.closeParensInLisp(retn);
            return retn.toString();
        }
        return null;
    }

    public void setJdeCompileOptionDirectory(File file) {
        this.jdeCompileOptionDirectory = file.getAbsolutePath();
    }

    private final String getJdeCompileOptionDirectoryLisp() {
        if (this.jdeCompileOptionDirectory != null) {
            StringBuffer retn = this.getStringBuffer();
            retn.append(" '(jde-compile-option-directory ");
            this.appendQuotedString(retn, this.jdeCompileOptionDirectory);
            this.closeParensInLisp(retn);
            return retn.toString();
        }
        return null;
    }

    public void setJdeSourcepath(File jdeSourcepath) {
        this.jdeSourcepath = jdeSourcepath;
    }

    private final String getJdeSourcepathLisp() {
        if (this.jdeSourcepath != null) {
            StringBuffer retn = this.getStringBuffer();
            retn.append(" '(jde-sourcepath (quote ( ");
            this.appendQuotedString(retn, this.jdeSourcepath.getAbsolutePath());
            this.closeParensInLisp(retn);
            return retn.toString();
        }
        return null;
    }

    public void execute() {
        Pattern pattern;
        Matcher match;
        if (this.projectFile == null) {
            throw new BuildException("projectfile attribute is mandatory");
        }
        this.project = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.projectFile)));
            while ((line = reader.readLine()) != null) {
                this.project.append(line + '\n');
            }
            reader.close();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        String startOptionsComment = " ;;Options added by JdeeTask";
        String endOptionsComment = " ;;end options added by JdeeTask";
        Pattern commentPattern = Pattern.compile(startOptionsComment + ".*?" + endOptionsComment, 32);
        Matcher commentMatch = commentPattern.matcher(this.project.toString());
        if (commentMatch.find()) {
            this.project.delete(commentMatch.start(), commentMatch.end() + 1);
        }
        if (!(match = (pattern = Pattern.compile("jde-set-variables")).matcher(this.project.toString())).find()) {
            throw new BuildException("Failed to find \"jde-set-variables\" line");
        }
        this.insertionPoint = match.end();
        this.insert(endOptionsComment);
        this.insert(this.getJdeGlobalClasspathLisp());
        this.insert(this.getJdeCompileOptionDirectoryLisp());
        this.insert(this.getJdeSourcepathLisp());
        this.insert(startOptionsComment);
        try {
            if (this.outFile == null) {
                this.outFile = this.projectFile;
            }
            FileWriter writer = new FileWriter(this.outFile);
            writer.write(this.project.toString());
            writer.close();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    private final void insert(String lisp) {
        if (lisp != null) {
            this.project.insert(this.insertionPoint, lisp);
            this.project.insert(this.insertionPoint, "\n");
        }
    }
}

