/*
 *  Copyright 2002 Phillip Lord, Victoria University of Manchester
 *
 *  This file is part of myGrid.  Further information, and the
 *  latest version, can be found at http://www.mygrid.info
 *
 *  myGrid is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  myGrid is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with myGrid; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package uk.ac.man.cs.img.xml.merge; 
import org.w3c.dom.Element;

/**
 * A UniquePredicate based on a id attribute. These are supposed to be 
 * unique within an XML document anyway. 
 *
 * Created: Wed Nov 27 22:03:40 2002
 *
 * @author Phillip Lord
 * @version $Id: UniqueIDAtttributePredicate.java,v 1.2 2002/12/10 14:30:59 lordp Exp $
 */

public class UniqueIDAtttributePredicate implements UniquePredicate
{
    private Element element;
    private static UniqueIDAtttributePredicate prototypeInstance
        = new UniqueIDAtttributePredicate();
    private String id;
    
    private UniqueIDAtttributePredicate()
    {
    }

    public static UniquePredicate prototypeInstance()
    {
        return prototypeInstance;
    }
    
    private UniqueIDAtttributePredicate( Element element )
    {
        this.element = element;
        this.id = element.getAttribute( "id" );
    }
    
    public boolean accept( Element element )
    {
        if( element.getAttribute( "id" ).equals( "" ) ){
            return false;
        }
        
        return true;
    }
    
    public Element getElement()
    {
        return element;
    }
    
    public UniquePredicate newInstance( Element element )
    {
        if( !accept( element ) ){
            throw new IllegalArgumentException
                ( "Element does not contain ID" );
        }
        
        return new UniqueIDAtttributePredicate( element );
    }
    
    public int hashCode()
    {
        if( this == prototypeInstance ){
            return super.hashCode();
        }
        
        return id.hashCode();
    }
    
    public boolean equals( Object obj )
    {
        if( ! (obj instanceof UniqueIDAtttributePredicate) ){
            return false;
        }
        
        return this.id.equals
            ( ((UniqueIDAtttributePredicate)obj).id );
    }
}



/*
 * ChangeLog
 * $Log: UniqueIDAtttributePredicate.java,v $
 * Revision 1.2  2002/12/10 14:30:59  lordp
 * Added boilerplate
 *
 * Revision 1.1  2002/12/04 17:19:51  lordp
 * Initial checkin
 *
 */
