#!/bin/sh


### THIS FILE MAY BE AUTOGENERATED. If you are reading "antmerge.sh"
### then it's generated from antmerge.sh.in....

### First locate the home directory of antmerge (I've stolen this from ant!)

## resolve links - $0 may be a symlink
PRG="$0"
progname=`basename "$0"`
saveddir=`pwd`

# need this for relative symlinks
cd `dirname "$PRG"`
  
while [ -h "$PRG" ] ; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '.*/.*' > /dev/null; then
	PRG="$link"
    else
	PRG=`dirname "$PRG"`"/$link"
    fi
done
  
ANTMERGE_HOME=`dirname "$PRG"`/..

cd "$saveddir"

# make it fully qualified
ANTMERGE_HOME=`cd "$ANTMERGE_HOME" && pwd`

USER_DIR=~/.antmerge


## The script identifies where to find classes, lib and so on relative
## to this shell script. This is fine, and should work in
## general. However the antmerge build enables you to move these files
## somewhere else, and still have the build work, which will then
## break the launch. So we get the ant build to set these directories
## up for us.
ANTMERGE_CLASSES=/home/phillord/extra/antmerge-generated/antmerge/build/classes
ANTMERGE_LIB=/home/phillord/extra/antmerge-generated/antmerge/lib
ANTMERGE_EXT=/home/phillord/extra/antmerge-generated/antmerge/ext

## However the default behaviour of the build is to set LIB, CLASSES
## and so forth to "./lib". So if the builder has not fiddled with
## these values CLASSES and so on will be set wrong. So check for the
## existence of antmerge.jar. If we can't find this, then just fall
## back to setting relative to ANTMERGE_HOME. 
if test ! -r $ANTMERGE_LIB/antmerge.jar
then
    ANTMERGE_EXT=$ANTMERGE_HOME/ext
    ANTMERGE_CLASSES=$ANTMERGE_HOME/build/classes
    ANTMERGE_LIB=$ANTMERGE_HOME/lib
fi



if test -r $ANTMERGE_CLASSES
then
    CLASSP=$ANTMERGE_CLASSES
    echo "**WARNING $0 is running in development mode, directly from class files**"
    echo "**WARNING delete the directory $ANTMERGE_CLASSES to     **"
    echo "**WARNING prevent this message                                        **"
else
    CLASSP=$ANTMERGE_LIB/antmerge.jar
fi

## Now that we have the home directory of antmerge, gather all the jar files up
for i in $ANTMERGE_EXT/*.jar
do
  CLASSP=$CLASSP:$i
done



java -Dprogram.name=$0 -Dinstallation.directory=$ANTMERGE_HOME \
    -Duser.extra.directory=$USER_DIR \
    -classpath $CLASSP uk.ac.man.cs.img.xml.merge.AntMerge $*
