#!/bin/sh 


## Copyright 2002, 2003, Victoria University of Manchester.

## This file is part of Antmerge, developed to support myGrid.
## Further information, and the latest version, can be found at
## http://www.mygrid.org.uk

## Antmerge is free software; you can redistribute it and/or modify
## it under the terms of the GNU Lesser General Public License as
## published by the Free Software Foundation; either version 2.1
## of the License, or (at your option) any later version.

## myGrid is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU Lesser General Public License for more details.
## You should have received a copy of the GNU Lesser General Public
## License along with Antmerge; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

## Author: Phillip Lord, Victoria University of Manchester
## Revision: $Id: antm.sh,v 1.5 2003/09/15 10:09:19 lordp Exp $



## Summary

## This is a convienience launch script. Use it instead of ant. 
##
## This overcomes a difficulty with antmerge, which uses ant to check
## to see whether the build files are out of date. This works fine,
## but ant will then run on the old build file which has already
## loaded. So sometimes you have to run ant twice to ensure that the
## build is complete. 
##
## This script automates the process for you. It runs ant twice, the
## first time to check whether antmerge is neeed, and the second time
## to do what ever it is you are running ant for. 

## This script assumes ant is in the system path, and accessible as
## "ant". 

ANT=ant

OPTIONS=$*

## we need to parse the command line options here, as some of the
## command line options need to be passed to both invocations of ant,
## while some do not
while [ -n "$1" ]
do 
  case $1 in
      -buildfile|-file| -f)
          shift
          BUILDFILE_OPT=-file
          BUILDFILE=$1
          ;;
      -find)
          shift
          FINDFILE_OPT=-find
          FINDFILE=$1
          ;;
      -verbose)
          VERBOSE=-verbose
          ;;
      -debug)
          DEBUG=-debug
          ;;
      -emacs)
          EMACS=-emacs
          ;;          
  esac
  shift
done


echo [antm] performing antmerge build. 
## rebuild build files if necessary. Pass in only those options
## enabling ant to find the build file. 
$ANT $EMACS $VERBOSE $DEBUG $FINDFILE_OPT $FINDFILE $BUILDFILE_OPT $BUILDFILE antmerge

echo [antm] performing main build
## do the build.
$ANT $OPTIONS