/*
 *  Copyright 2002 Phillip Lord, Victoria University of Manchester
 *
 *  This file is part of myGrid.  Further information, and the
 *  latest version, can be found at http://www.mygrid.info
 *
 *  myGrid is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  myGrid is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with myGrid; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package uk.ac.man.cs.img.xml.merge; // Generated package name

import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import java.util.regex.Matcher;

public class SuperVarUniqueAttributeTagPredicate extends UniqueAttributeTagPredicate
    implements AdaptableUniquePredicate
{
    
    private String attributeContainingSuper;
    
    public SuperVarUniqueAttributeTagPredicate
        ( String tagName, String attributeName,
          String attributeContainingSuper )
    {
        super( tagName, attributeName );
        this.attributeContainingSuper = attributeContainingSuper;
    }
    
    protected SuperVarUniqueAttributeTagPredicate
        ( Element element, String tagName, String attributeName,
          String attributeContainingSuper )
    {
        super( element, tagName, attributeName );
        this.attributeContainingSuper = attributeContainingSuper;
    }
    
    public UniquePredicate newInstance( Element element )
    {
        acceptOrExcept( element );
        
        return new SuperVarUniqueAttributeTagPredicate
            ( element, tagName, attributeName, attributeContainingSuper );
    }
    
    private Pattern pattern = Pattern.compile
        ( "\\$\\{super\\}" );
    
    public Element adaptChild( Element parent, Element child )
    {
        Attr childAtt = child.getAttributeNode( attributeContainingSuper );
        String childAttVal =  childAtt.getValue();
        
        Matcher matcher = pattern.matcher( childAttVal );
        
        if( matcher.find() ){
            String parentAtt = parent.getAttribute( attributeContainingSuper );
            
            // think this should be replace first...
            String replaced = matcher.replaceAll( parentAtt );
            childAtt.setValue( replaced );
        }
        
        return child;
    }
}

                                                      
