/*
 *  Copyright 2002 Phillip Lord, Victoria University of Manchester
 *
 *  This file is part of myGrid.  Further information, and the
 *  latest version, can be found at http://www.mygrid.info
 *
 *  myGrid is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  myGrid is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with myGrid; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package uk.ac.man.cs.img.xml.merge; // Generated package name

import org.w3c.dom.Element;

/**
 * UniqueAttributeTagPredicate.java
 *
 * A wrapper for elements, where for a specific tag name, the value of 
 * one attribute represents an unique identifier within the document. 
 *
 * Created: Fri Nov 29 13:55:57 2002
 *
 * @author Phillip Lord
 * @version $Id: UniqueAttributeTagPredicate.java,v 1.3 2003/09/08 11:02:58 lordp Exp $
 */

public class UniqueAttributeTagPredicate implements UniquePredicate
{
    private Element element;
    
    protected String tagName;
    protected String attributeName;
    
    private boolean isPrototypeInstance = false;

    public UniqueAttributeTagPredicate( String tagName, 
                                        String attributeName )
    {    
        this.tagName = tagName;
        this.attributeName = attributeName;
        this.isPrototypeInstance = true;
    }

    protected UniqueAttributeTagPredicate
        ( Element element, String tagName, 
          String attributeName )
    {
        this( tagName, attributeName );
        this.element = element;
        isPrototypeInstance = false;
    }
    
    public UniquePredicate newInstance( Element element )
    {
        acceptOrExcept( element );
        return new UniqueAttributeTagPredicate
            ( element, this.tagName, this.attributeName );
    }
    
    protected void acceptOrExcept( Element element )
    {
        if( !accept( element ) ){
            throw new IllegalArgumentException
                ( "Element is not of name " + tagName + 
                  " with attribute " + attributeName );
        }
    }
    
    public boolean accept( Element element )
    {
        if( element.getNodeName().equals( tagName ) &&
            !element.getAttribute( attributeName ).equals( "" ) ){
            return true;
        }
        return false;
    }

    public Element getElement()
    {
        return element;
    }
    
    public int hashCode()
    {
        if( isPrototypeInstance ){
            return super.hashCode();
        }
        return element.getAttribute( attributeName ).hashCode();
    }
    
    public boolean equals( Object object )
    {
        if( !(object instanceof UniqueAttributeTagPredicate ) ){
            return false;
        }
        
        UniqueAttributeTagPredicate obj = 
            (UniqueAttributeTagPredicate)object;
        
        return (this.attributeName.equals( obj.attributeName ) ) &&
            (this.tagName.equals( obj.tagName ) ) &&
            (this.element.getAttribute( attributeName ).equals
             ( obj.element.getAttribute( attributeName ) ) );
    }
    
} // UniqueAttributeTagPredicate



/*
 * ChangeLog
 * $Log: UniqueAttributeTagPredicate.java,v $
 * Revision 1.3  2003/09/08 11:02:58  lordp
 * Changes to allow better sub classing.
 *
 * Revision 1.2  2002/12/10 14:30:59  lordp
 * Added boilerplate
 *
 * Revision 1.1  2002/12/04 17:19:51  lordp
 * Initial checkin
 *
 */
