/*
 *  Copyright 2002 Phillip Lord, Victoria University of Manchester
 *
 *  This file is part of myGrid.  Further information, and the
 *  latest version, can be found at http://www.mygrid.info
 *
 *  myGrid is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  myGrid is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with myGrid; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package uk.ac.man.cs.img.xml.merge; // Generated package name

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

public class SuperTagUniqueAttributeTagPredicate extends UniqueAttributeTagPredicate
    implements AdaptableUniquePredicate
{
    
    public SuperTagUniqueAttributeTagPredicate( String tagName, 
                                        String attributeName )
    {    
        super( tagName, attributeName );
    }

    protected SuperTagUniqueAttributeTagPredicate
        ( Element element, String tagName, 
          String attributeName )
    {
        super( element, tagName, attributeName );
    }

    
    public UniquePredicate newInstance( Element element )
    {
        acceptOrExcept( element );
        
        return new SuperTagUniqueAttributeTagPredicate
            ( element, tagName, attributeName );
        
    }    

    public Element adaptChild( Element parent, Element child )
    {
        // Are there any nodes which are super elements
        NodeList list = child.getElementsByTagName( "super" );
        
        if( list.getLength() > 0 ){
            // get the first super node. 
            Node superNode = list.item( 0 );
            
            // get all the children of the parent
            NodeList parentContents = parent.getElementsByTagName( "*" );
            
            // now insert the children of the parent element, before
            // the super node
            for( int i = 0; i < parentContents.getLength(); i++ ){
                child.insertBefore( parentContents.item( i ), superNode );
            }
            
            // and clean up by deleting the super node
            child.removeChild( superNode );
        }

        return child;
    }
}

                                                    
