/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.xml.merge;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.man.cs.img.xml.merge.AdaptableUniquePredicate;
import uk.ac.man.cs.img.xml.merge.UniquePredicate;

public class MergeDocuments {
    private UniquePredicate[] predicates;

    public Document merge(Document mainDoc, Document mergeDoc, Document outputDoc) {
        Map mergeMap = this.generateUniques(mergeDoc);
        this.recurseTreeForMerge(mainDoc.getDocumentElement(), outputDoc, outputDoc, mergeMap);
        Iterator iter = mergeMap.values().iterator();
        while (iter.hasNext()) {
            Element node = (Element)iter.next();
            outputDoc.getDocumentElement().appendChild(outputDoc.importNode(node, true));
        }
        return outputDoc;
    }

    private final void recurseTreeForMerge(Node current, Node currentOutput, Document outputDocument, Map mergeMap) {
        UniquePredicate predicate;
        Node mergeNode = current;
        if (current instanceof Element && (predicate = this.getUniquePredicate((Element)current)) != null) {
            Element element = (Element)current;
            if (mergeMap.get(predicate) != null) {
                Node newOutputNode = outputDocument.importNode((Element)mergeMap.get(predicate), true);
                if (predicate instanceof AdaptableUniquePredicate) {
                    Element importElement = (Element)outputDocument.importNode(element, true);
                    newOutputNode = ((AdaptableUniquePredicate)predicate).adaptChild(importElement, (Element)newOutputNode);
                }
                currentOutput.appendChild(newOutputNode);
                mergeMap.remove(predicate);
                return;
            }
        }
        Node newOutputNode = outputDocument.importNode(mergeNode, false);
        currentOutput.appendChild(newOutputNode);
        NodeList children = current.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            this.recurseTreeForMerge(children.item(i), newOutputNode, outputDocument, mergeMap);
            ++i;
        }
    }

    private final UniquePredicate getUniquePredicate(Element element) {
        int i = 0;
        while (i < this.predicates.length) {
            if (this.predicates[i].accept(element)) {
                return this.predicates[i].newInstance(element);
            }
            ++i;
        }
        return null;
    }

    private final Map generateUniques(Document document) {
        LinkedHashMap<UniquePredicate, Element> retn = new LinkedHashMap<UniquePredicate, Element>();
        NodeList children = document.getDocumentElement().getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            UniquePredicate predicate;
            Node child = children.item(i);
            if (child instanceof Element && (predicate = this.getUniquePredicate((Element)child)) != null) {
                retn.put(predicate, predicate.getElement());
            }
            ++i;
        }
        return retn;
    }

    public MergeDocuments(UniquePredicate[] predicates) {
        this.predicates = predicates;
    }
}

