(defvar learn-language-spanish-from-to
  '(spanish english))

(defvar learn-language-spanish-0
  '(("el libro" "the book")
    ("la pluma" "the pen")
    ("Qu es esto?" "What is this?")
    ("el lpiz" "the pencil")
    ("la caja" "the box")
    ("es el libro" "it is the book")
    ("el papel" "the paper")
    ("la llave" "the key")
    ("es esto el lpiz?" "is it the pencil?")
    ("s, es el lpiz" "yes, it is the pencil")
    ("es esto la caja, seor?" "is this the box, sir?")
    ("No, seor, no es la caja, sino la pluma"
     "No, sir, it is not the box, but the pen")
    ("la silla" "the chair")
    ("la mesa" "the table")
    ("la lmpara" "the lamp")
    ("la puerta" "the door")
    ("la ventana" "the window")
    ("el cuadro" "the picture")
    ("Seorita, es esto la lmpara o la silla?"
     "Miss, is this the lamp or the chair")
    ("Qu es esto?" "What is this?")
    ("es la pared" "it is the wall")
    ("el piso" "the floor")
    ("el cielo raso" "the ceiling")
    ("Muy bien!" "Very well!")
    ("uno" "one") ("dos" "two") ("tres" "three")
    ("cuatro" "four") ("cinco" "five")))

(defvar learn-language-spanish-1
  '(("el saco" "the jacket")
    ("el sombrero" "the hat")
    ("es esto el sombrero?" "is this the hat?")
    ("el pantaln" "the trousers")
    ("Que es esto, el pantaln o la falda?" 
     "What are these, the trousers or the skirt?")
    ("el abrigo" "the overcoat")
    ("el traje" "the suit or dress")
    ("la falda" "the skirt")
    ("la cartera" "the handbag")
    ("es esto el sombrero?" "is this the hat?")
    ("si, seor, es el sombrero" "yes, sir, it is the hat")
    ("es esto la saco o el pantaln?"
     "is this the jacket or the trousers?")
    ("es el saco" "it is the jacket")
    ("el dinero" "the money")
    ("la corbata" "the tie")
    ("Que es esto, la corbata o el quante?"
     "What is this? The tie or the glove?")
    ("el reloj" "the watch")
    ("la camisa" "the shirt")
    ("la media" "the stocking")
    ("el guante" "the glove")
    ("el pauelo" "the handkerchief")
    ("que es esto, la cartera o el dinero?"
     "What is it, the handbag, or the money?")
    ("Excelente!" "Excellent!")
    ("Hasta maana!" "Until tomorrow!")))
    
(defvar learn-language-spanish-2
  '(("negro" "black")
    ("rojo" "red")
    ("amarillo" "yellow")
    ("gris" "grey")
    ("blanco" "white")
    ("pardo" "brown")
    ("verde" "green")
    ("azul" "blue")
    ("el lpiz es pardo" "the pencil is brown")
    ("el telfono es negro" "the telephone is black")
    ("el libro es azul" "the book is blue")
    ("el papel es blanco" "the paper is white")
    ("el cielo raso es blanco" "the ceiling is white")
    ("el sombrero es verde" "the hat is green")
    ("Que es esto? Es el libro" "What is that? It is the book")
    ("De qu color es el libro?" "What colour is the book?")
    ("El libro es azul" "the book is blue")
    ("Que es esto?" "What is that?")
    ("Es el cielo raso" "It is the ceiling")
    ("De qu color el cielo raso?" "What color is the ceiling?")
    ("El cielo raso es blanco" "The ceiling is white")
    ("De qu color es el sombrero?  Es verde."
     "What colour is the hat? It is green.")
    ("Es pardo el lpiz?" "Is the pencil brown?" )
    ("S, seor, el lpiz es pardo" "Yes, sir, the pencil is brown")
    ("Es verde el lpiz?" "Is the pencil green?")
    ("No, seor, el lpiz no es verde." "No, sir, the pencil is not green")
    ("Es negro el lpiz?" "Is the pencil black?")
    ("No, no es negro" "No, its not black")
    ("De qu color es el lpiz" "What colour is the pencil")
    ("El lpiz es pardo" "The pencil is brown")
    ("Es pardo el libro" "Is the book brown" )
    ("No, seor, el libro no es pardo" "No, sir, the book is not brown")
    ("De qu color es el libro?" "What colour is the book?")
    ("El libro es azul" "the book is blue")
    ("De qu color es el sombrero" "What colour is the hat")
    ("El sombrero es verde" "the hat is green")
    ("De qu color es el tlfono?" 
     "What colour is the telephone?")
    ("el tlfono es negro" "the telephone is black")
    ("De que color es la pluma?" "What colour is the pen")
    ("la pluma es negro" "the pen is black")))
 
(defvar learn-language-spanish-3
  '(("el lpiz negro es largo" "the black pencil is long")
    ("el lpiz rojo no es largo;es corto" 
     "the red pencil is not long; it is short")
    ("la regla amarilla es larga" "the yellow ruler is long")
    ("la regla negra es corta" "the black ruler is short")
    ("Es largo el lpiz negro?" "Is the black pencil large?")
    ("Es corto el lpiz negro?" "Is the black pencil short?")
    ("Es corto el lpiz rojo?" "Is the red pencil short?")
    ("Es largo o corto el lpiz negro?" 
     "Is the black pencil short or long")
    ("El libro pardo es ancho" "The brown book is wide")
    ("el libro rojo no es ancho, es estrecho" 
     "The red book is not wide, it is narrow")
    ("La avenida es ancha" "The avenue is wide")
    ("la calle es estrecha" "the street is narrow")
    ("Es ancha la avenida?" "Is the avenue wide?")
    ("Es estrecha la calle?" "Is the street narrow?")
    ("El libro pardo es largo y ancho" "The brown book is long and wide")
    ("es grande" "it is large")
    ("el libro rojo es corto y estrecho" 
     "the red book is short and narrow")
    ("es pequeo" "it is small")
    ("la ventana es grande." "the window is large")
    ("la mesa es pequea" "the table is small")
    ("Es grande el libro verde?" "Is the green book large?")
    ("De qu color es el libro pequeo?" "What colour is the small book?")
    ("De qu color es el libro grande?" "What colour is the large book?")
    ("Es grande la mesa?" "Is the table large?")
    ("Es pequea la puerta?" "Is the door small?")
    ("Es grande el papel rojo?" "Is the red paper large?")
    ("De qu color es el libro pequeo?" "What colour is the small book?")
    ("De qu color es el libro grande?" "What colour is the large book?")
    ("Es grande el Brasil?" "Is Brazil large?")
    ("Es Cuba grande o pequea?" "Is Cuba large or small?")
    ("once" "eleven")("doce" "12")("trece" "13")("catorce" "14")
    ("quince" "fifteen") ("Buenas tardes!" "Good afternoon!")))

(defvar learn-language-spanish-4
  '(("Un seor (un caballero)" "A gentleman")
    ("una seora" "A lady")
    ("una seorita" "a young lady")
    ("Este caballero es el seor Berlitz"
     "This gentleman is Mr. Berlitz?")
    ("esta seora es la seora Berlitz"
     "this lady is Mrs Berlitz")
    ("esta seorita es la seorita Berlitz"
     "this young lady is Miss Berlitz")
    ("Es este caballero el Sr. Berlitz?"
     "Is this gentlemen Mr Berlitz")
    ("S, l es" "Yes, he is")
    ("No, no es" "No, he is not")
    ("Es esta seora la Sra. Berlitz?" "Is this lady Mrs. Berlitz")
    ("S, seor, ella es" "yes, sir, she is")
    ("No, no es" "No she is not")
    ("Es este seor, el Sr. Lpez?", "Is this gentleman Mr. Lopez?")
    ("Es el Sr. Galds?" "Is he Mr. Galdos?")
    ("Es el Sr. Mndez?" "Is he Mr Mendez?")
    ("Quin es este seor?" "Who is this gentlemen?")
    ("Quin es esta seora?" "Who is this lady?")
    ("Este seor es el Sr. Prez" "This gentleman is Mr Perez")
    ("Esta seora es el Sra. Villa" "This lady is Mrs Villa")
    ("Esta seorita es la Srta. Fuentes" "This lady is Miss Fuentes")
    ("Usted es el Sr. Fulano" "You are Mr Fulano")
    ("Yo soy el Sr Berlitz." "I am Mr Berlitz")
    ("Usted es el alumno" "You are the pupil")
    ("Yo soy el profesor" "I am the teacher")
    ("Es Ud. el Sr. Ortiz?" "Are you Mr. Ortiz?")
    ("S, yo soy el Sr. Ortiz?" "Yes, I am Mr. Ortiz?")
    ("Soy yo el Sr. Jimnez?" "Am I Mr. Jimenez?")
    ("No, Ud. no es Sr. Jimnez" "No, you are not Mr Jimenez")
    ("Quin soy yo?" "Who am I?")
    ("Quin soy Ud.?" "Who are you?")
    ("Quin es esta seora?" "Who is this lady?")
    ("Es la Sra. Crdoba" "She is Mrs Cordoba")
    ("Quin es el Sr. Cucaln?" "Who is Mr Cucalon?")
    ("Ud. es" "You are")
    ("Quin es el Srta. Quevedo?" "Who is Miss Quevedo?")
    ("Yo soy la Srta. Quevedo" "I am Miss Quevedo?")
    ("Quin soy yo?" "Who am I?")
    ("Ud. es el Sr. Berlitz" "You are Mr Berlitz")
    ("Quin es este caballero?" "Who is this gentleman?")
    ("Es el Sr. Prez" "He is Mr Perez")
    ("Quin es esta seora?" "Who is this lady?")
    ("Es la Sra. Villa" "She is Mrs Villa")
    ("Quin es esta seorita?" "Who is this lady?")
    ("Es esta Srta. Fuentes" "Is is Miss Fuentes")
    ("Yo soy espaol" "I am Spanish")
    ("Ud. es norteamericano" "You are North American")
    ("El Sr. Rivera es mexicano" "Mr Rivera is Mexican")
    ("El Sr. Torres es peruano" "Mr Torres is Peruvian")
    ("Soy yo norteamericano?" "Am I North American?")
    ("No, seor, Ud. no es norteamericano"
     "No, sir, you are not North American")
    ("Ud. es espaol" "You are Spanish")
    ("Es Ud. espaol?" "Are you Spanish?")
    ("No, seor, yo no soy espaol" "No, Sir, you are not Spanish")
    ("yo soy norteamericano" "I am North American")
    ("el el Sr. Rivera argentino?" "Is Mr Rivera Argentinian?")
    ("No, seor, l no es argentino." 
     "No, sir, he is not Argentinian")
    ("es Mexicano" "He is Mexican")
    ("diez y seis" "sixteen")
    ("diez y siete" "seventeen")
    ("diez y ocho" "eighteen")
    ("diez y nueve" "nineteen")
    ("veinte" "twenty")))
     
(defvar learn-language-spanish-5
  '(("Este sombrero es negro" "This hat is black")
    ("ese sombrero es verde" "that hat is green")
    ("aquel sombrero es gris" "that hat is grey")
    ("Qu sombrero es negro?" "Which hat is black?")
    ("ste" "This one (ms)")
    ("Qu sombrero?" "Which hat is green?")
    ("se" "That one (ms)")
    ("Qu sombreror es gris?" "Which hat is grey?")
    ("Aqul" "that (far) one")
    ("Esta regla es negra" "This ruler is black")
    ("esa regla es amarilla" "that ruler is yellow")
    ("aquella regla es blanca" "that ruler is white")
    ("Qu regla es negra?" "Which ruler is black?")
    ("sta" "This one (fm)")
    ("Qu regla es amarilla?" "Which ruler is yellow?")
    ("sa" "that one (fm)")
    ("Qu regla es blanco?" "Which ruler is white?")
    ("Aqulla" "That (far) one (fm)")
    ("ste es mi libro" "This is my book")
    ("su libro de Ud." "your book")
    ("el libro del Sr...." "the book of Mr...")
    ("sta es mi pluma" "This is my pen" )
    ("su pluma" "your pen")
    ("la pluma de la Sra. Caldern" "Miss Calderon's pen")
    ("su sombrero de Ud." "your hat")
    ("el sombrero del Sr...." "the hat of Mr...")
    ("Qu es esto?" "What is this?")
    ("Es mi libro" "It is my book")
    ("Es ste el guante del Sr. Mena" "Is this Mr Mens glove?")
    ("S, es su guante (de l)" "Yes, it is his glove")
    ("Es ste mu libro?" "Is this my book?")
    ("S, seor, es su libro de Ud." "Yes, sir, it is my book")
    ("Es ste su traje o su cuello" "Is this your suit or your collar?")
    ("No es mi traje ni mi cuello; es mi pauelo"
     "It is neither my suit nor my collar; it is handkerchief")))
;; upto page 24


(defun learn-language-spanish-festival-hook
  (phrase type)
  (interactive)
  (cond
   ((eq type 'spanish)
    (language-speak-say-spanish phrase))
   ((eq type 'english)
    (language-speak-say-english phrase))))

(require 'language-speak)
(require 'festival)
(add-hook 'learn-language-message-hook 
          'learn-language-spanish-festival-hook)

(provide 'learn-language-spanish)

;; Local Variables: ***
;; eval: (set-input-method "spanish-postfix") ***
;; End: ***
