(require 'festival)

(defvar language-speak-say-spanish t)

(defun language-speak-say-spanish(phrase)
  (interactive)
  (if language-speak-say-spanish
      (language-speak-say 
       (language-speak-spanish-fix-unknowns phrase)
       '(voice_el_diphone))))


(defun language-speak-spanish-fix-unknowns(phrase)
  (let ((retn phrase))
    (setq retn (replace-regexp-in-string "" "i" retn))
    (setq retn (replace-regexp-in-string "" "o" retn))
    (setq retn (replace-regexp-in-string "" "O" retn))
    (setq retn (replace-regexp-in-string "" "" retn))))

(defvar language-speak-say-english t)

(defun language-speak-say-english(phrase)
  (interactive)
  (if language-speak-say-english
      (language-speak-say phrase '(voice_kal_diphone))))

;;(language-speak-say "Now is the winter of our discontent made glorious" '(voice_ked_diphone))

(defun language-speak-say-spanish-line( &optional noerror )
  (interactive)
  (save-excursion
    (beginning-of-line)
    (let ((delimiter (search-forward language-speak-delimiter 
                                     (line-end-position) t)))
      (if delimiter
          (language-speak-say-spanish
           (buffer-substring-no-properties
            (line-beginning-position)
            (- delimiter
               (length language-speak-delimiter))))
        (if (not noerror)
            (message "Can't find delimiter"))))))

(defun language-speak-say-english-line( &optional noerror)
  (interactive)
  (save-excursion
    (beginning-of-line)
    (let ((delimiter 
           (search-forward language-speak-delimiter
                           (line-end-position) t)))
      (if delimiter
          (language-speak-say-english
           (buffer-substring-no-properties
            delimiter
            (line-end-position)))
        (if (not noerror)
            (message "Can't find delimiter"))))))


(defun language-speak-say(phrase diphone)
  (message "Saying %s..." phrase)
  (festival-send-command diphone)
  (festival-say-string phrase))



(defun language-speak-insert-delimiter()
  (interactive)
  (insert language-speak-delimiter))

(defun language-speak-new-line()
  (interactive)
  (language-speak-say-line t)
  (newline))

(defun language-speak-advance-say-line()
  (interactive)
  (forward-line)
  (language-speak-say-line))

(defun language-speak-advance-say-spanish-line()
  (interactive)
  (forward-line)
  (language-speak-say-spanish-line))

(defun language-speak-advance-say-english-line()
  (interactive)
  (forward-line)
  (language-speak-say-english-line))

(defun language-speak-say-line( &optional noerror )
  (interactive)
  (language-speak-say-spanish-line noerror)
  (language-speak-say-english-line noerror))

(defun language-speak-say-mouse-line(event)
  (interactive "e")
  (mouse-set-point event)
  (language-speak-say-line))

(defvar language-speak-delimiter " >>>> ")

(define-derived-mode
  language-speak-mode
  text-mode
  "LangSpeak"
  (progn (set-input-method "spanish-postfix")
         (flyspell-mode 0)))

   
(define-key language-speak-mode-map [f1] 'language-speak-say-spanish-line)
(define-key language-speak-mode-map [f2] 'language-speak-say-english-line)
(define-key language-speak-mode-map [f3] 'language-speak-say-line)
(define-key language-speak-mode-map [f4] 'language-speak-advance-say-spanish-line)
(define-key language-speak-mode-map [f5] 'language-speak-advance-say-english-line)
(define-key language-speak-mode-map [f6] 'language-speak-advance-say-line)
(define-key language-speak-mode-map "\t" 'language-speak-insert-delimiter)
(define-key language-speak-mode-map "\C-m" 'language-speak-new-line)
(define-key language-speak-mode-map [mouse-1] 'language-speak-say-mouse-line)

(add-to-list 'auto-mode-alist
             '("\\.lang\\'" . language-speak-mode))


(font-lock-add-keywords
 'language-speak-mode
 (list (cons language-speak-delimiter font-lock-keyword-face)
       (list (concat "\\(.*\\)" language-speak-delimiter)  1 font-lock-string-face)
       (list (concat language-speak-delimiter "\\(.*\\)") 1 font-lock-type-face)))

(font-lock-add-keywords
 'language-speak-mode
 '(("#.*" 0 font-lock-comment-face)))

(provide 'language-speak)