// File: Person.java

// Import
import java.util.Enumeration;
import java.util.Vector;


/**
 * This class holds information about an individual person.
 * 
 * @author Vegard Brox
 */
public class Person
{
   /**
    * A constant value representing males
    */
   public static final int MALE     = 0;
   /**
    * A constant value representing females
    */
   public static final int FEMALE   = 1;

   // Private member variables
   private String    myID           = null;
   private YearRange myBirth        = null;
   private YearRange myDeath        = null;
   private YearRange myChristening  = null;
   private YearRange myBurial       = null;
   private int       mySex          = 0;  
   private String    myCFamily      = null;
   private Vector    mySFamilies    = null;
      
   /**
    * Constructor that initialise an object with the specified values.
    * 
    * @param id ID of the person
    * @param birth A year range for the birth date of the person
    * @param death A year range for the death date of the person
    * @param christening A year range for the christening date of the person
    * @param burial A year range for the burial date of the person
    * @param sex The sex of the person - either MALE or FEMALE
    * @param cFamily The ID of the family where this person is a child
    * @param sFamilies A vector of IDs of families where this person is a spouse
    */
   public Person( String id, YearRange birth, YearRange death, 
                  YearRange christening, YearRange burial, int sex,
                  String cFamily, Vector sFamilies )
   {
      myID = id;
      myBirth = birth;
      myDeath = death;
      myChristening = christening;
      myBurial = burial;
      mySex = sex;
      myCFamily = cFamily;
      mySFamilies = sFamilies;
   }
   
   /**
    * Returns the ID of the person
    * @return The ID as a string
    */
   public String getID()
   {
      return myID;
   }

   /**
    * Returns the birth date of the person
    * @return A year range for the birth date of the person
    */
   public YearRange getBirth()
   {
      return myBirth;
   }

   /**
    * Returns the death date of the person
    * @return A year range for the death date of the person
    */
   public YearRange getDeath()
   {
      return myDeath;
   }

   /**
    * Returns the christening date of the person
    * @return A year range for the christening date of the person
    */
   public YearRange getChristening()
   {
      return myChristening;
   }

   /**
    * Returns the burial date of the person
    * @return A year range for the burial date of the person
    */
   public YearRange getBurial()
   {
      return myBurial;
   }
   
   /**
    * Returns if the person is a male
    * @return True if the person is male, false otherwise
    */
   public boolean isMale()
   {
      return ( mySex == MALE );
   }
   
   /**
    * Returns if the person is a female
    * @return True if the person is female, false otherwise
    */
   public boolean isFemale()
   {
      return ( mySex == FEMALE );
   }
   
   /**
    * Returns the ID of the family where this person is a child
    * @return The ID of the family where this person is a child
    */
   public String getCFamily()
   {
      return myCFamily;
   }
   
   /**
    * Returns IDs of families where this person is a spouse
    * @return An enumeration containing IDs of families where 
    *  this person is a spouse
    */
   public Enumeration getSFamilies()
   {
      return mySFamilies.elements();
   }
   
   /**
    * Returns a string representation of this object.
    * @return The ID of this person, which is a string 
    *  representation of the object
    */
   public String toString()
   {
      return myID;
   }
}
