// File: MainProgramW.java

// Import
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;


/**
 * This class represents the main program for the GUI version
 * of the GEDCOM Estimator.
 *
 * @author Vegard Brox
 */
public class MainProgramW
{
   // Not supposed to create instances of this class
   private MainProgramW()
   {}

   /**
    * The main program. Opens up the main window in the application.
    *
    * @param args The command-line arguments, none of which are used
    */
   public static void main( String args[] )
   {
      MainWindow window = new MainWindow();
      window.addWindowListener( new MainProgramW().new MyEventHandler() );
      window.show();
   }

   /**
    * Event handler class for the GUI main program.
    */
   private class MyEventHandler extends WindowAdapter
   {
      /**
       * Called when the window receives a close command. Closes the window.
       *
       * @param e The window event
       */
      public void windowClosing( WindowEvent e )
      {
         e.getWindow().dispose();
      }
      
      /**
       * Called when the window has been closed. Terminates the program.
       *
       * @param e The window event
       */
      public void windowClosed( WindowEvent e )
      {
         System.exit( 0 );
      }
   }
}
