// File: GEDCOMInput.java

//Import
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.Vector;

/**
 * This class has the overall responsibility for reading a GEDCOM file and
 * build an internal database from it.
 *
 * @author Vegard Brox
 */
public class GEDCOMInput
{
   /**
    * Uses the GEDCOMLocater class to read the specified input file.
    * Person and Family objects are created based on the input file, 
    * and placed in the specified hashtables.
    *
    * @param file The GEDCOM file to read from
    * @param people A hashtable where Person objects should be added
    * @param families A hashtable where Family objects should be added
    */
   public static void input( File file, Hashtable people, Hashtable families ) 
      throws FileNotFoundException
   {
      GEDCOMLocater locater = new GEDCOMLocater( file );
      Person person = locater.nextPerson();
      while( person != null )
      {
         people.put( person.getID(), person );
         person = locater.nextPerson();
      }
      
      Family family = locater.nextFamily();
      while( family != null )
      {
         families.put( family.getID(), family );
         family = locater.nextFamily();
      }
   }
}

