// File: Family.java

// Import
import java.util.Enumeration;
import java.util.Vector;

/**
 * This class holds information about a family, with references
 * to husband, wife and children, and marriage data.
 *
 * @author Vegard Brox
 */
public class Family
{
   // Private variables
   private String myID           = null;
   private YearRange myMarriage  = null;
   private String myHusband      = null;
   private String myWife         = null;
   private Vector myChildren     = null;
   
   /**
    * Constructor that initialises the class with specified values
    *
    * @param id The family ID
    * @param marriage A year range representing the marriage date
    * @param husband The ID of the husband in the family
    * @param wife The ID of the wife in the family
    * @param children A vector of strings with IDs of the children
    */
   public Family( String id, YearRange marriage, String husband, 
                  String wife, Vector children )
   {
      myID = id;
      myMarriage = marriage;
      myHusband = husband;
      myWife = wife;
      myChildren = children;
   }
   
   /**
    * Returns the family ID
    * @return The family ID
    */
   public String getID()
   {
      return myID;
   }
   
   /**
    * Returns the marriage date
    * @return A year range representing the marriage date
    */
   public YearRange getMarriage()
   {
      return myMarriage;
   }
   
   /**
    * Returns the husband
    * @return A string with the ID of the husband
    */
   public String getHusband()
   {
      return myHusband;
   }
   
   /**
    * Returns the wife
    * @return A string with the ID of the wife
    */
   public String getWife()
   {
      return myWife;
   }
   
   /**
    * Returns the children
    * @return An enumeration of strings with IDs of the children
    */
   public Enumeration getChildren()
   {
      return myChildren.elements();
   }
   
   /**
    * Returns a string representation of this object.
    * @return The ID of this family, which is a string
    *  representation of this object
    */
   public String toString()
   {
      return myID;
   }
}
