// File: DateLogEntry.java

/**
 * This is a simple class that can work as a log entry in a log of dates.
 * It contains an ID and a date identifier, both stored as strings.
 *
 * @author Vegard Brox
 */
public class DateLogEntry
{
   // Private variables
   private String myID;
   private String myDate;

   /**
    * Creates a new date log entry initialised with the specified values.
    *
    * @param id The ID that owns this date
    * @date the type of date this is
    */
   public DateLogEntry( String id, String date )
   {
      myID = id;
      myDate = date;
   }
   
   /**
    * Returns the ID.
    * @return the ID
    */
   public String getID()
   {
      return myID;
   }
   
   /**
    * Returns the date.
    * @return the date
    */
   public String getDate()
   {
      return myDate;
   }
   
   /**
    * Returns a string representation of this object.
    * @return a string representation of this object
    */
   public String toString()
   {
      return myID + "." + myDate;
   }
}

