// File: AboutBox.java

// Import 
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * This class represents an about box for the GEDCOM Estimator.
 *
 * @author Vegard Brox
 */
public class AboutBox extends Dialog
{
   /**
    * Creates a new, initially invisible about box with version and 
    * copyright information.
    *
    * @param parent The parent frame of the about box
    */
   public AboutBox( Frame parent )
   {
      // Call Dialog constructor
      super( parent, "About GEDCOM Estimator", true );
      
      // Create GUI
      Panel labelPanel = new Panel( new GridLayout( 4, 1 ) );
      labelPanel.add( new Label( "GEDCOM Estimator version 1.0 (May 2000)" ) );
      labelPanel.add( new Label( "Copyright \u00a9 2000 Vegard Brox" ) );
      labelPanel.add( new Label( "This program may be freely used " +
                                  "and distributed." ) );
      labelPanel.add( new Label( "Please refer to the documentation " +
                                  "for more info." ) );
      Button okButton = new Button( "   OK   " );
      okButton.addActionListener( new MyEventHandler() );
      Panel buttonPanel = new Panel();
      buttonPanel.add( okButton );
      
      // Add to dialog
      add( "Center", labelPanel );
      add( "South", buttonPanel );
      pack();
      
      // Set location
      setLocation( parent.getLocation().x - 10, parent.getLocation().y + 30 );
   }
   
   /**
    * Event handler for the about box.
    */
   private class MyEventHandler implements ActionListener
   {
      /**
       * Called automatically when OK button is pressed. Closes the window.
       *
       * @param e The action event that happened
       */
      public void actionPerformed( ActionEvent e )
      {
         AboutBox.this.dispose();
      }
   }
}
