<?php
    require("config.php");
    $mysqli = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli->connect_errno){ die("Could not connect to database: " . $mysqli->connect_errno); }

    $result = $mysqli->query("SELECT * FROM Task ORDER BY startDate");

    $tasks = array();

    while($row = $result->fetch_assoc()){
        $thisTask = array(
            "id" => $row["taskId"],
            "name" => $row["name"],
            "description" => $row["description"],
            "startDate" => $row["startDate"],
            "deadline" => $row["deadline"],
            "completed" => $row["completed"]
        );

        array_push($tasks, $thisTask);

    }

?>


<!DOCTYPE html>
<html>
    <head>
        <title>Tasks</title>
        <link rel="stylesheet" href="styles.css">
    </head>
    <body>

        <?php include("templates/navbar.php"); ?>

        <div id="wrapper">
            
            <h1>Task List</h1>
            <p>This page shows all tasks in the project</p>

            <?php
                foreach($tasks as $task){

                    ?>

                    <div class="task">
                        <h3><?php echo($task["name"]); ?> <?php echo( ($task["completed"] == 1 ? "(Completed)" : "(Incomplete)") ); ?></h3>
                        <p><?php echo($task["description"]); ?></p>
                        <a href="taskdetails.php?id=<?php echo($task["id"]); ?>">Task Details</a>
                        <a href="taskdelete.php?id=<?php echo($task["id"]); ?>">Delete</a>


                    </div>


                    <?php

                }


            ?>


            <a href="createtask.php">[+] Create new task</a>


        </div>


    </body>
</html>
