<?php
    require("config.php");
    $mysqli = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli->connect_errno){ die("Could not connect to database: " . $mysqli->connect_errno); }

    $taskID = $_GET["id"];

    $stmt = $mysqli->prepare("SELECT taskId, name, description, startDate, deadline, completed, newDeadline FROM Task WHERE `taskId`=?");

    $stmt->bind_param("i", $taskID);

    //Variables to put the result of the query into
    /*$task["id"];
    $task["name"];
    $task["description"];
    $task["startDate"];
    $task["deadline"];
    $task["completed"];
    $task["newDeadline"];*/

    //Tells mysql server to execute prepared statement
    $stmt->execute();

    //Variables to store properties in when fetch() is called
    $stmt->bind_result($task["id"], $task["name"], $task["description"], $task["startDate"], $task["deadline"], $task["completed"], $task["newDeadline"]);

    //Store the properties from the query in the variables bound above
    $stmt->fetch();

    /*Get members working on task*/
    $mysqli2 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli2->connect_errno){ die("Could not connect to database: " . $mysqli2->connect_errno); }
    
    $stmtGetMembers = $mysqli2->prepare("SELECT TeamMember.userID, TeamMember.firstName, TeamMember.lastName, TeamMember.status FROM TeamMember LEFT JOIN Assign ON TeamMember.userID = Assign.userID WHERE Assign.taskID = ?");

    $stmtGetMembers->bind_param("i", $taskID);

    //Variables to put the result of the query into
    /*$member["userID"];
    $member["firstName"];
    $member["lastName"];
    $member["status"];*/

    $stmtGetMembers->execute();

    $stmtGetMembers->bind_result($member["userID"], $member["firstName"], $member["lastName"], $member["status"]);

    $membersList = Array();

    //fetch - returns true if there is another row in the results
    while($stmtGetMembers->fetch()){
        $thisMember = Array(
            "userID" => $member["userID"],
            "firstName" => $member["firstName"],
            "lastName" => $member["lastName"],
            "status" => $member["status"]
        );
        array_push($membersList, $thisMember);
    }
    /*End get memners working on task*/

    /*Get list of all members*/
    $mysqli3 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli3->connect_errno){ die("Could not connect to database: " . $mysqli3->connect_errno); }

    $stmtGetAllMembers = $mysqli3->prepare("SELECT userID, firstName, LastName FROM TeamMember");

    /*$allMemberResult["userID"];
    $allMemberResult["firstName"];   
    $allMemberResult["lastName"];*/

    $stmtGetAllMembers->execute();

    $stmtGetAllMembers->bind_result($allMemberResult["userID"], $allMemberResult["firstName"], $allMemberResult["lastName"]);

    $allMembers = Array();

    while($stmtGetAllMembers->fetch()){
        $currentMember = Array(
            "userID" => $allMemberResult["userID"],
            "firstName" => $allMemberResult["firstName"],
            "lastName" => $allMemberResult["lastName"]
        );
        array_push($allMembers, $currentMember);
    }
    /*End get list of all members*/

    /*Get prereq tasks*/
    $mysqli4 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli4->connect_errno){ die("Could not connect to database: " . $mysqli4->connect_errno); }

    $stmtGetPrereq = $mysqli4->prepare("SELECT Task.taskId, Task.name, Task.completed FROM Task, Prerequisite WHERE Task.taskId = Prerequisite.prereqTask_id AND Prerequisite.primaryTask_id=?");

    $stmtGetPrereq->bind_param("i", $taskID);

    /*$pretask["taskId"];
    $pretask["name"];
    $pretask["completed"];*/

    $stmtGetPrereq->execute();

    $stmtGetPrereq->bind_result($pretask["taskId"], $pretask["name"], $pretask["completed"]);

    $preTaskList = Array();

    //fetch - returns true if there is another row in the results
    while($stmtGetPrereq->fetch()){
        $thisPreTask = Array(
            "taskId" => $pretask["taskId"],
            "name" => $pretask["name"],
            "completed" => $pretask["completed"]
        );
        array_push($preTaskList, $thisPreTask);
    }
    /*End get prereq tasks*/

    /*Get all tasks*/
    $mysqli5 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli5->connect_errno){ die("Could not connect to database: " . $mysqli5->connect_errno); }

    $stmtGetAllTasks = $mysqli5->prepare("SELECT taskId, name FROM Task");

    /*$allTaskResult["taskId"];
    $allTaskResult["name"];*/


    $stmtGetAllTasks->execute();

    $stmtGetAllTasks->bind_result($allTaskResult["taskId"], $allTaskResult["name"]);

    $alltasks = Array();

    while($stmtGetAllTasks->fetch()){
        $currentTask = Array(
            "taskId" => $allTaskResult["taskId"],
            "name" => $allTaskResult["name"]
        );
        array_push($alltasks, $currentTask);
    }
    /*End get all tasks*/

     /*Calculate days left until due date*/
    $now = time();
    $taskDeadline = strtotime($task["deadline"]);
    $datediff = $taskDeadline - $now;
    $daystodeadline = round($datediff / (60 * 60 * 24));
    
 /*Calculate days from original due date after extension*/
    $taskNewDeadline = $task["newDeadline"];
    $taskNewDeadlineCalculation = strtotime($task["newDeadline"]);
    $datediff2 = $taskNewDeadlineCalculation - $taskDeadline;
    $daysExtended = round($datediff2 / (60 * 60 * 24));




?>


<!DOCTYPE html>
<html>
    <head>
        <title>Tasks</title>
        <link rel="stylesheet" href="styles.css">
    </head>
    <body>

        <?php include("templates/navbar.php"); ?>

        <div id="wrapper">
            
            <h1><?php echo($task["name"]); ?></h1>
            <p><?php echo($task["description"]); ?></p>
            <p>Start Date: <?php echo($task["startDate"]); ?></p>
            
            
            
            <p>Deadline: <?php echo($task["deadline"]); ?> 
            
            <?php
            
            if($daystodeadline > 0){
                echo("(Due in " . $daystodeadline . " days)");
            } else {
                echo("(Overdue, due " . abs($daystodeadline) . " days ago)");
            }
            ?>
            <p>Extension:

            <?php
            
            if($taskNewDeadline == null) {
                echo("No extensions made");
            }
            else {
                
                echo(" " . $taskNewDeadline . " (Extended with " . $daysExtended . " \ndays)"); 
            }

            ?>
            </p>
            <p>Current Status: <?php echo($task["completed"] == 1 ? "Completed" : "Incomplete"); ?></p>

            <a href="edittask.php?id=<?php echo($task["id"]); ?>">Edit task</a>

            <hr>

            <h2>Prerequisite Tasks</h2>
            <?php
                
                if(count($preTaskList) == 0){
                    echo("<p>This task currently has no prerequisite tasks assigned. </p>");
                } else {
                
                    foreach($preTaskList as $preTask){

                        ?>
                        
                        <div class="assignedTask">
                            <div class="assignedTask-left">
                                <span class="assignedTask-name"><?php echo($preTask["name"]);?></span> | <span class="assignedTask-completed"><?php echo( ($preTask["completed"] == 1 ? "(Completed)" : "(Incomplete)") ); ?></span>
                            </div>
                            <div class="assignedTask-right">
                                <a href='taskDetails.php?id=<?php echo($preTask["taskId"]) ?>'>Task Info</a> <a href='removeprerequisite.php?prereqtaskid=<?php echo($preTask["taskId"]); ?>&primarytaskid=<?php echo($taskID); ?>'>Remove</a>
                            </div>
                
                        



                        </div>

                        <?php
                        
                    }

                }
            ?>

            <form action="assigprerequisitetask.php" method="get">
            <input type="hidden" name="primarytaskid" value="<?php echo($taskID); ?>" />
            <select name="prereqtaskid" required>
                <option disabled selected value="">Assign a prerequisite task...</option>
                    
                    <?php

                        foreach($alltasks as $selectedTask){
                            $isAlreadyAssigned2 = false;
                            foreach($preTaskList as $existingprereq){
                                if($existingprereq["taskId"] === $selectedTask["taskId"]){
                                    $isAlreadyAssigned2 = true;
                                }
                                if($taskID == $selectedTask["taskId"]){
                                    $isAlreadyAssigned2 = true;
                                }
                            }
                            if($taskID == $selectedTask["taskId"]){
                                $isAlreadyAssigned2 = true;
                            }
                            if(!$isAlreadyAssigned2){

                                ?>
                                
                                    <option value="<?php echo($selectedTask["taskId"]);?>"><?php echo($selectedTask["name"]); ?></option>

                                <?php

                            }
                        }

                    ?>


            </select>

                        


        <button type="submit">Add</button>
        </form>

            <hr>


            <h2>Assigned Members</h2>
            <?php
                
                if(count($membersList) == 0){
                    echo("<p>No members currently assigned. </p>");
                } else {
                
                    foreach($membersList as $member){

                        ?>
                        
                        <div class="assignedMember">
                            <div class="assignedMember-left">
                                <span class="assignedMember-name"><?php echo($member["firstName"] . " " . $member["lastName"]);?></span> | <span class="assignedMember-status"><?php echo($member["status"]); ?></span>
                            </div>
                            <div class="assignedMember-right">
                                <a href='memberdetails.php?id=<?php echo($member["userID"]) ?>'>Member Info</a> <a href='unassignmember.php?userid=<?php echo($member["userID"]); ?>&taskid=<?php echo($taskID); ?>'>Un-assign</a>
                            </div>
                            
                        



                        </div>

                        <?php
                        
                    }

                }
            ?>

            <form action="assignmember.php" method="get">

                <input type="hidden" name="taskid" value="<?php echo($taskID); ?>" />
                <select name="userid" required>
                    <option disabled selected value="">Assign another user...</option>
                        
                        <?php

                            foreach($allMembers as $member){
                                $isAlreadyAssigned = false;
                                foreach($membersList as $assignee){
                                    if($assignee["userID"] === $member["userID"]){
                                        $isAlreadyAssigned = true;
                                    }
                                }

                                if(!$isAlreadyAssigned){

                                    ?>

                                        <option value="<?php echo($member["userID"]);?>"><?php echo($member["firstName"] . " " . $member["lastName"]); ?></option>

                                    <?php

                                }
                            }

                        ?>


                </select>

                <button type="submit">Assign</button>
            </form>

            <hr>

            <a href="tasks.php">Back</a>

        </div>


    </body>
</html>