<?php
    require("config.php");
    $mysqli = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli->connect_errno){ die("Could not connect to database: " . $mysqli->connect_errno); }

    $result = $mysqli->query("SELECT userID, firstName, lastName, dateOfBirth, gender, userName, status, userPassword FROM TeamMember");

    $members = array();

    while($row = $result->fetch_assoc()){
        $thisMember = array(
            "userID" => $row["userID"],
            "firstName" => $row["firstName"],
            "lastName" => $row["lastName"],
            "dateOfBirth" => $row["dateOfBirth"],
            "gender" => $row["gender"],
            "userName" => $row["userName"],
            "status" => $row["status"],
            "userPassword" => $row["userPassword"]
        );

        array_push($members, $thisMember);

    }

?>


<!DOCTYPE html>
<html>
    <head>
        <title>Members</title>
        <link rel="stylesheet" href="styles.css">
    </head>
    <body>

        <?php include("templates/navbar.php"); ?>

        <div id="wrapper">
            
            <h1>Member List</h1>
            <p>This page shows all members working on the project</p>

            <?php
                foreach($members as $member){

                    ?>

                    <div class="task">
                        <h3><?php echo($member["firstName"]); ?></h3>
                        <p><?php echo($member["status"]); ?></p>
                        <a href="memberdetails.php?id=<?php echo($member["userID"]); ?>">Member Details</a>
                        <a href="memberdelete.php?id=<?php echo($member["userID"]); ?>">Delete</a>

                    </div>


                    <?php

                }


            ?>


            <a href="createmember.php">[+] Create new member</a>


        </div>


    </body>
</html>