<?php
    require("config.php");
    $mysqli = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli->connect_errno){ die("Could not connect to database: " . $mysqli->connect_errno); }

    $result = $mysqli->query("SELECT name, startDate, deadline, completed FROM Task");

    $taskInfo = array();

    while($row = $result->fetch_assoc()){
            $thisTask = array(
            "nameOfTask" => $row["name"],
            "startDateOfTask" => $row["startDate"],
            "deadlineOfTask" => $row["deadline"],
            "isTaskCompleted" => $row["completed"]
            );
            array_push($taskInfo, $thisTask);
    }

    
    /*Get the latest deadline*/
    $mysqli2 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli2->connect_errno){ die("Could not connect to database: " . $mysqli2->connect_errno); }

    $stmt = $mysqli2->prepare("SELECT max(deadline) FROM Task");

    //Variables to put the result of the query into
    $max["deadline"];

    //Tells mysql server to execute prepared statement
    $stmt->execute();

    //Variables to store properties in when fetch() is called
    $stmt->bind_result($max["deadline"]);

    //Store the properties from the query in the variables bound above
    $stmt->fetch();
    /*End get the latest deadline*/

    /*Get the latest newDeadline*/
    $mysqli3 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli3->connect_errno){ die("Could not connect to database: " . $mysqli3->connect_errno); }

    $stmt2 = $mysqli3->prepare("SELECT max(newDeadline) FROM Task");

    //Variables to put the result of the query into
    $max["newDeadline"];

    //Tells mysql server to execute prepared statement
    $stmt2->execute();

    //Variables to store properties in when fetch() is called
    $stmt2->bind_result($max["newDeadline"]);

    //Store the properties from the query in the variables bound above
    $stmt2->fetch();
    /*End get the latest newDeadline*/


    $finalDeadline = $max["deadline"];
    if($max["newDeadline"] > $max["deadline"]){
      $finalDeadline = $max["newDeadline"];
    }


    /*Get project info*/
    $mysqli4 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli4->connect_errno){ die("Could not connect to database: " . $mysqli4->connect_errno); }

    $stmt3 = $mysqli4->prepare("SELECT projectId, deadline, projectName, requirements, completed FROM Project WHERE projectId = 1");

    //Variables to put the result of the query into
    $project["projectId"];
    $project["deadline"];
    $project["projectName"];
    $project["requirements"];
    $project["completed"];

    //Tells mysql server to execute prepared statement
    $stmt3->execute();

    //Variables to store properties in when fetch() is called
    $stmt3->bind_result($project["projectId"], $project["deadline"], $project["projectName"], $project["requirements"], $project["completed"]);

    //Store the properties from the query in the variables bound above
    $stmt3->fetch();
    /*End get project info*/


    /*Get total number of members*/
    $mysqli5 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli5->connect_errno){ die("Could not connect to database: " . $mysqli5->connect_errno); }

    $stmt4 = $mysqli5->prepare("SELECT count(*) FROM TeamMember;");

    //Variables to put the result of the query into
    $numberOfMembers["total"];

    //Tells mysql server to execute prepared statement
    $stmt4->execute();

    //Variables to store properties in when fetch() is called
    $stmt4->bind_result($numberOfMembers["total"]);

    //Store the properties from the query in the variables bound above
    $stmt4->fetch();
    /*End get total number of members*/

    /*Get tasks a member is working on*/

    $mysqli6 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli6->connect_errno){ die("Could not connect to database: " . $mysqli6->connect_errno); }
    
    $stmtGetCurrentTasks = $mysqli6->prepare("SELECT distinct TeamMember.firstName, TeamMember.lastName, TeamMember.userID, TeamMember.taskId, Task.completed, Task.name FROM TeamMember, Task WHERE TeamMember.taskId = Task.taskId");

    $cmember["firstName"];
    $cmember["lastName"];
    $cmember["userID"];
    $cmember["taskId"];
    $cmember["completed"];
    $cmember["taskName"];

    $stmtGetCurrentTasks->execute();

    $stmtGetCurrentTasks->bind_result($cmember["firstName"], $cmember["lastName"], $cmember["userID"], $cmember["taskId"], $cmember["completed"], $cmember["taskName"]);

    $workingOnList = Array();

    //fetch - returns true if there is another row in the results
    while($stmtGetCurrentTasks->fetch()){
        $currentTask = Array(
            "firstName" => $cmember["firstName"],
            "lastName" => $cmember["lastName"],
            "userID" => $cmember["userID"],
            "taskId" => $cmember["taskId"],
            "completed" => $cmember["completed"],
            "taskName" => $cmember["taskName"]
        );
        array_push($workingOnList, $currentTask);
    }

    /*End get tasks a member is working on*/


  
?>

<!DOCTYPE html>
<html>
    <head>
        <title>Project Overview</title>
        <link rel="stylesheet" href="styles.css">

        
  
  <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
  <script type="text/javascript">
    
    google.charts.load('current', {'packages':['gantt']});
    google.charts.setOnLoadCallback(drawChart);

    function daysToMilliseconds(days) {
      return days * 24 * 60 * 60 * 1000;
    }

    function drawChart() {

      var data = new google.visualization.DataTable();
      data.addColumn('string', 'Task ID');
      data.addColumn('string', 'Task Name');
      data.addColumn('date', 'Start Date');
      data.addColumn('date', 'End Date');
      data.addColumn('number', 'Duration');
      data.addColumn('number', 'Percent Complete');
      data.addColumn('string', 'Dependencies');

      var arrayOfData = JSON.parse( '<?php echo json_encode($taskInfo) ?>' );

      var arrayLength = arrayOfData.length;

      for (var i = 0; i < arrayLength; i++) {
        var name = arrayOfData[i].nameOfTask;

        var start = arrayOfData[i].startDateOfTask;

        var startYear = start.substr(0, 4);
        var startMonth = start.substr(5, 2);
        var startDay = start.substr(8, 2);

        var end = arrayOfData[i].deadlineOfTask;

        var endYear = end.substr(0, 4);
        var endMonth = end.substr(5, 2);
        var endDay = end.substr(8, 2);

        var isComplete = arrayOfData[i].isTaskCompleted;
        var completedNumber;
        if(isComplete == 1){
          completedNumber = 100;
        }
        else{
          completedNumber = 0;
        }

        data.addRows([
        [name, name,
         new Date(startYear, startMonth, startDay), new Date(endYear, endMonth, endDay), null, completedNumber,  null]
      ]);

      }
    
      /*console.log(arrayOfData[0].nameOfTask);
      console.log(arrayOfData[0].startDateOfTask);
      console.log(arrayOfData[0].deadlineOfTask);*/

      

      var options = {
        height: (42 + (42 * arrayLength))
      };

      var chart = new google.visualization.Gantt(document.getElementById('chart_div'));

      chart.draw(data, options);
    }
  </script>

    </head>
    <body>

        <?php include("templates/navbar.php"); ?>

        <div id="wrapper">
            
            <h1>Project Management System</h1>
            <h2>Project Name: <?php echo($project["projectName"]); ?></h2>
            <a href="editproject.php">Edit Project Details</a>
            <h3>Description</h3>
            <p><?php echo($project["requirements"]);  ?></p>
            <h2>Overview</h2>
            <div id="chart_div"></div>

            <h2>Project Stats</h2>
            <p>Deadline: <?php echo($project["deadline"]); ?></p>
            <p>Status: <?php if($finalDeadline > $project["deadline"]){ echo("Overdue. Estimated completion date is currently: " . $finalDeadline); } else { echo("Ontime"); } ?></p>
            <p>Total Members: <?php echo($numberOfMembers["total"]); ?></p>
            <hr>
            <h2>Current Tasks</h2>
            <?php
                            
              if(count($workingOnList) == 0){
                  echo("<p>No tasks currently assigned. </p>");
              } else {
              
                  foreach($workingOnList as $currentTasks){

                    if($currentTasks["completed"] == 0){

                    

                      ?>
                      
                      <div class="assignedTask">
                          <div class="assignedTask-left">
                              <span class="assignedTask-name"><?php echo($currentTasks["firstName"] . " " . $currentTasks["lastName"]);?></span> | <span class="assignedTask-completed"><?php echo($currentTasks["taskName"]); ?></span>
                          </div>
                          <div class="assignedTask-right">
                              <a href='taskDetails.php?id=<?php echo($currentTasks["taskId"]) ?>'>Task Info</a> 
                          </div>
                          
                      </div>

                      <?php

                    } else {
                      ?>
                      
                      <div class="assignedTask">
                          <div class="assignedTask-left">
                              <span class="assignedTask-name"><?php echo($currentTasks["firstName"] . " " . $currentTasks["lastName"]);?></span> | <span class="assignedTask-completed"><?php echo($currentTasks["taskName"] . " (Task Completed)"); ?></span>
                          </div>
                          <div class="assignedTask-right">
                              <a href='taskDetails.php?id=<?php echo($currentTasks["taskId"]) ?>'>Task Info</a> 
                          </div>
                          
                      </div>

                      <?php

                    }
                      
                  }

              }
            ?>

    </body>
</html>