<?php
    require("config.php");
    $mysqli = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli->connect_errno){ die("Could not connect to database: " . $mysqli->connect_errno); }

    $taskID = $_GET["id"];

    $stmt = $mysqli->prepare("SELECT taskId, name, description, startDate, deadline, completed, newDeadline FROM Task WHERE `taskId`=?");

    $stmt->bind_param("i", $taskID);

    //Variables to put the result of the query into
    $task["id"];
    $task["name"];
    $task["description"];
    $task["startDate"];
    $task["deadline"];
    $task["completed"];
    $task["newDeadline"];

    //Tells mysql server to execute prepared statement
    $stmt->execute();

    //Variables to store properties in when fetch() is called
    $stmt->bind_result($task["id"], $task["name"], $task["description"], $task["startDate"], $task["deadline"], $task["completed"], $task["newDeadline"]);

    //Store the properties from the query int he variables bound above
    $stmt->fetch();

    /*Get prerequisite tasks*/
    $mysqli2 = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli2->connect_errno){ die("Could not connect to database: " . $mysqli2->connect_errno); }

    $stmtGetPrereq = $mysqli2->prepare("SELECT Task.taskId, Task.name, Task.completed FROM Task, Prerequisite WHERE Task.taskId = Prerequisite.prereqTask_id AND Prerequisite.primaryTask_id=?");

    $stmtGetPrereq->bind_param("i", $taskID);

    $pretask["taskId"];
    $pretask["name"];
    $pretask["completed"];

    $stmtGetPrereq->execute();

    $stmtGetPrereq->bind_result($pretask["taskId"], $pretask["name"], $pretask["completed"]);

    $preTaskList = Array();

    //fetch - returns true if there is another row in the results
    while($stmtGetPrereq->fetch()){
        $thisPreTask = Array(
            "taskId" => $pretask["taskId"],
            "name" => $pretask["name"],
            "completed" => $pretask["completed"]
        );
        array_push($preTaskList, $thisPreTask);
    }
    /*End get prereq tasks*/

    $completedDisabled = false;

    foreach($preTaskList as $taskToCheck){
        if($taskToCheck["completed"] == 0){
            $completedDisabled = true;
        }
    }





?>


<!DOCTYPE html>
<html>
    <head>
        <title>Edit Task</title>
        <link rel="stylesheet" href="styles.css">
    </head>
    <body>

        <?php include("templates/navbar.php"); ?>

        <div id="wrapper">

        <h1>Edit Task</h1>
        <p>Please fill in the following information to edit the task.</p>

        <form method="POST" action="edittask_result.php">
            <fieldset>
                <legend>Edit Task</legend>
                    <p>Task Name: <input type="text" name="name" placeholder="Type Task Name" value="<?php echo($task["name"]); ?>"/></p>
                    <p>Task Description: <input type="text" name="description" placeholder="Type Task Description" value="<?php echo($task["description"]); ?>"/></p>

                    <fieldset>
                        <legend>Dates</legend>
                        <p>Start Date: <input type="date" name="startDate" value="<?php echo($task["startDate"]); ?>"></p>
                        <p>Deadline: <input type="date" name="deadline" value="<?php echo($task["deadline"]); ?>"></p>
                        <p>New Deadline: <input type="date" name="newDeadline" value="<?php echo($task["newDeadline"]); ?>"></p>
                    </fieldset>

                    <p>Completed: <input type="checkbox" <?php if($completedDisabled == true){ echo("disabled");}?> name="completed" value="yes" <?php echo($task["completed"] == 1 ? "checked" : ""); ?>><?php if($completedDisabled == true){ echo(" (All prerequisite tasks must be completed first)");}?></p>

                <input type="hidden" name="id" value="<?php echo($task["id"]); ?>" />
                <input type="submit" value="Save Task" />    
            </fieldset>

        </form>

        <a href="taskdetails.php?id=<?php echo($taskID); ?>">Back</a>

        </div>

    </body>
</html>