<?php
    require("config.php");
    $mysqli = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli->connect_errno){ die("Could not connect to database: " . $mysqli->connect_errno); }

    $projectId = 1;

    $stmt = $mysqli->prepare("SELECT projectId, deadline, projectName, requirements, completed FROM Project WHERE projectId=1");


    //Variables to put the result of the query into
    $project["projectId"];
    $project["deadline"];
    $project["projectName"];
    $project["requirements"];
    $project["completed"];

    //Tells mysql server to execute prepared statement
    $stmt->execute();

    //Variables to store properties in when fetch() is called
    $stmt->bind_result($project["projectId"], $project["deadline"], $project["projectName"], $project["requirements"], $project["completed"]);

    //Store the properties from the query in the variables bound above
    $stmt->fetch();

?>


<!DOCTYPE html>
<html>
    <head>
        <title>Edit Project</title>
        <link rel="stylesheet" href="styles.css">
    </head>
    <body>

        <?php include("templates/navbar.php"); ?>

        <div id="wrapper">

        <h1>Edit Project</h1>
        <p>Please fill in the following information to edit the project.</p>


        <form method="POST" action="editproject_results.php">
            <fieldset>
                    <legend>Edit Project</legend>
                        <p>Project name: <input type="text" name="projectName" placeholder="Type Project Name" value="<?php echo($project["projectName"]); ?>"/></p>
                        <p>Description: <input type="text" name="requirements" placeholder="Type project description" value="<?php echo($project["requirements"]); ?>"/></p>
                        <p>Deadline: <input type="date" name="deadline" placeholder="Type project deadline" value="<?php echo($project["deadline"]); ?>"/></p>


                    <input type="hidden" name="id" value="<?php echo($projectId); ?>" />
                    <input type="submit" value="Submit" />    
                </fieldset>
        

        </form>

        <a href="index.php">Back</a>

        </div>

    </body>
</html>