<?php
    require("config.php");
    $mysqli = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli->connect_errno){ die("Could not connect to database: " . $mysqli->connect_errno); }

    $userID = $_GET["id"];

    $stmt = $mysqli->prepare("SELECT userID, firstName, lastName, dateOfBirth, gender, userName, status, userPassword FROM TeamMember WHERE `userID`=?");

    $stmt->bind_param("i", $userID);

    //Variables to put the result of the query into
    $member["userID"];
    $member["firstName"];
    $member["lastName"];
    $member["dateOfBirth"];
    $member["gender"];
    $member["userName"];
    $member["status"];
    $member["userPassword"];

    //Tells mysql server to execute prepared statement
    $stmt->execute();

    //Variables to store properties in when fetch() is called
    $stmt->bind_result($member["userID"], $member["firstName"], $member["lastName"], $member["dateOfBirth"], $member["gender"], $member["userName"], $member["status"], $member["userPassword"]);

    //Store the properties from the query in the variables bound above
    $stmt->fetch();

?>


<!DOCTYPE html>
<html>
    <head>
        <title>Edit Member</title>
        <link rel="stylesheet" href="styles.css">
    </head>
    <body>

        <?php include("templates/navbar.php"); ?>

        <div id="wrapper">

        <h1>Edit Member</h1>
        <p>Please fill in the following information to edit the member.</p>


        <form method="POST" action="editmember_result.php">
            <fieldset>
                    <legend>Edit Team Member</legend>
                        <p>First name: <input type="text" name="firstName" placeholder="Type first Name" value="<?php echo($member["firstName"]); ?>"/></p>
                        <p>Last name: <input type="text" name="lastName" placeholder="Type last Name" value="<?php echo($member["lastName"]); ?>"/></p>
                        <p>Gender: <input type="text" name="gender" placeholder="Type gender" value="<?php echo($member["gender"]); ?>"/></p>
                        <p>Date of birth: <input type="date" name="dateOfBirth" placeholder="Type date of birth" value="<?php echo($member["dateOfBirth"]); ?>"/></p>
                        <p>Status: <input type="text" name="status" placeholder="Type status" value="<?php echo($member["status"]); ?>"/></p>

                        <fieldset>
                            <legend>User Details</legend>
                            <p>User name: <input type="text" name="userName" placeholder="Type username" value="<?php echo($member["userName"]); ?>"/></p>
                            <p>Password: <input type="password" name="userPassword" placeholder="Type password" value="<?php echo($member["userPassword"]); ?>"/></p>
                            
                        </fieldset>

                    <input type="hidden" name="id" value="<?php echo($member["userID"]); ?>" />
                    <input type="submit" value="Submit" />    
                </fieldset>
        

        </form>

        <a href="memberdetails.php?id=<?php echo($userID); ?>">Back</a>

        </div>

    </body>
</html>