<?php
    require("config.php");
    $mysqli = new mysqli($db_server, $db_user, $db_password, $db_database);
    if($mysqli->connect_errno){ die("Could not connect to database: " . $mysqli->connect_errno); }

    $stmt = $mysqli->prepare("INSERT INTO Task (`name`, `description`, `startDate`, `deadline`, `completed`) VALUES (?, ?, ?, ?, ?)");

    $taskName = $_POST["name"];
    $taskDescription = $_POST["description"];
    $taskStart = strtotime($_POST["startDate"]);
    $taskDeadline = strtotime($_POST["deadline"]);
    $taskCompleted = 0;

    $stmt->bind_param("ssssi", $taskName, $taskDescription, date("Y-m-d", $taskStart), date("Y-m-d", $taskDeadline), $taskCompleted);
    
    $success = $stmt->execute();



?>


<!DOCTYPE html>
<html>
    <head>
        <title>Tasks</title>
        <link rel="stylesheet" href="styles.css">
        <!-- Redirects the browser after 1 second to the tasks page -->
        <meta http-equiv="refresh" content="1;url=tasks.php?" /> 
    </head>
    <body>

        <?php include("templates/navbar.php"); ?>

        <div id="wrapper">
            

            <h1><?php if($success){echo("Task added!");} else { echo("Error adding task");} ?></h1>



        </div>


    </body>
</html>