# Validators

## Types

  * [ArrayVal](ArrayVal.md)
  * [ArrayType](ArrayType.md)
  * [BoolVal](BoolVal.md)
  * [BoolType](BoolType.md)
  * [CallableType](CallableType.md)
  * [Countable](Countable.md)
  * [Date](Date.md)
  * [FalseVal](FalseVal.md)
  * [FloatVal](FloatVal.md)
  * [FloatType](FloatType.md)
  * [Instance](Instance.md)
  * [IntVal](IntVal.md)
  * [IntType](IntType.md)
  * [IterableType](IterableType.md)
  * [NullType](NullType.md)
  * [Numeric](Numeric.md)
  * [ObjectType](ObjectType.md)
  * [ResourceType](ResourceType.md)
  * [ScalarVal](ScalarVal.md)
  * [StringType](StringType.md)
  * [TrueVal](TrueVal.md)
  * [Type](Type.md)
  * [Xdigit](Xdigit.md)

## Generics

  * [AlwaysInvalid](AlwaysInvalid.md)
  * [AlwaysValid](AlwaysValid.md)
  * [Call](Call.md)
  * [Callback](Callback.md)
  * [FilterVar](FilterVar.md)
  * [Not](Not.md)
  * [Optional](Optional.md)
  * [Type](Type.md)
  * [When](When.md)

## Comparing Values

  * [Age](Age.md)
  * [Between](Between.md)
  * [Equals](Equals.md)
  * [Identical](Identical.md)
  * [Max](Max.md)
  * [Min](Min.md)

## Numeric

  * [Between](Between.md)
  * [BoolType](BoolType.md)
  * [Even](Even.md)
  * [Factor](Factor.md)
  * [Fibonacci](Fibonacci.md)
  * [Finite](Finite.md)
  * [FloatVal](FloatVal.md)
  * [FloatType](FloatType.md)
  * [Infinite](Infinite.md)
  * [IntVal](IntVal.md)
  * [IntType](IntType.md)
  * [Multiple](Multiple.md)
  * [Negative](Negative.md)
  * [NotEmpty](NotEmpty.md)
  * [Numeric](Numeric.md)
  * [Odd](Odd.md)
  * [PerfectSquare](PerfectSquare.md)
  * [Positive](Positive.md)
  * [PrimeNumber](PrimeNumber.md)
  * [Roman](Roman.md)
  * [Xdigit](Xdigit.md)

## String

  * [Alnum](Alnum.md)
  * [Alpha](Alpha.md)
  * [Between](Between.md)
  * [Charset](Charset.md)
  * [Cntrl](Cntrl.md)
  * [Consonant](Consonant.md)
  * [Contains](Contains.md)
  * [Digit](Digit.md)
  * [EndsWith](EndsWith.md)
  * [Graph](Graph.md)
  * [In](In.md)
  * [Length](Length.md)
  * [Lowercase](Lowercase.md)
  * [NotEmpty](NotEmpty.md)
  * [NoWhitespace](NoWhitespace.md)
  * [PhpLabel](PhpLabel.md)
  * [Prnt](Prnt.md)
  * [Punct](Punct.md)
  * [Regex](Regex.md)
  * [ResourceType](ResourceType.md)
  * [Slug](Slug.md)
  * [Space](Space.md)
  * [StartsWith](StartsWith.md)
  * [Uppercase](Uppercase.md)
  * [Version](Version.md)
  * [Vowel](Vowel.md)
  * [Xdigit](Xdigit.md)

## Arrays

  * [ArrayVal](ArrayVal.md)
  * [ArrayType](ArrayType.md)
  * [Contains](Contains.md)
  * [Each](Each.md)
  * [EndsWith](EndsWith.md)
  * [In](In.md)
  * [Key](Key.md)
  * [KeyNested](KeyNested.md)
  * [KeySet](KeySet.md)
  * [KeyValue](KeyValue.md)
  * [Length](Length.md)
  * [NotEmpty](NotEmpty.md)
  * [StartsWith](StartsWith.md)

## Objects

  * [Attribute](Attribute.md)
  * [Instance](Instance.md)
  * [Length](Length.md)

## Date and Time

  * [Age](Age.md)
  * [Between](Between.md)
  * [Date](Date.md)
  * [LeapDate](LeapDate.md)
  * [LeapYear](LeapYear.md)
  * [MinimumAge](MinimumAge.md)

## Group Validators

  * [AllOf](AllOf.md)
  * [NoneOf](NoneOf.md)
  * [OneOf](OneOf.md)

## Regional

  * [CountryCode](CountryCode.md)
  * [CurrencyCode](CurrencyCode.md)
  * [IdentityCard](IdentityCard.md)
  * [LanguageCode](LanguageCode.md)
  * [PostalCode](PostalCode.md)
  * [SubdivisionCode](SubdivisionCode.md)
  * [Tld](Tld.md)

## Files

  * [Directory](Directory.md)
  * [Executable](Executable.md)
  * [Exists](Exists.md)
  * [Extension](Extension.md)
  * [File](File.md)
  * [Image](Image.md)
  * [Mimetype](Mimetype.md)
  * [Readable](Readable.md)
  * [Size](Size.md)
  * [SymbolicLink](SymbolicLink.md)
  * [Uploaded](Uploaded.md)
  * [Writable](Writable.md)

## Banking

  * [Bank](Bank.md)
  * [BankAccount](BankAccount.md)
  * [Bic](Bic.md)

## Other

  * [Bsn](Bsn.md)
  * [Cnh](Cnh.md)
  * [Cnpj](Cnpj.md)
  * [Cpf](Cpf.md)
  * [Domain](Domain.md)
  * [Email](Email.md)
  * [HexRgbColor](HexRgbColor.md)
  * [Imei](Imei.md)
  * [Ip](Ip.md)
  * [Json](Json.md)
  * [MacAddress](MacAddress.md)
  * [NfeAccessKey](NfeAccessKey.md)
  * [NotBlank](NotBlank.md)
  * [NotOptional](NotOptional.md)
  * [Pesel](Pesel.md)
  * [Phone](Phone.md)
  * [Sf](Sf.md)
  * [Url](Url.md)
  * [VideoUrl](VideoUrl.md)
  * [Zend](Zend.md)

## Yes/No

  * [No](No.md)
  * [Yes](Yes.md)

## Alphabetically

  * [Age](Age.md)
  * [AllOf](AllOf.md)
  * [Alnum](Alnum.md)
  * [Alpha](Alpha.md)
  * [AlwaysInvalid](AlwaysInvalid.md)
  * [AlwaysValid](AlwaysValid.md)
  * [ArrayVal](ArrayVal.md)
  * [ArrayType](ArrayType.md)
  * [Attribute](Attribute.md)
  * [Bank](Bank.md)
  * [BankAccount](BankAccount.md)
  * [Between](Between.md)
  * [Bic](Bic.md)
  * [BoolType](BoolType.md)
  * [Bsn](Bsn.md)
  * [Call](Call.md)
  * [CallableType](CallableType.md)
  * [Callback](Callback.md)
  * [Charset](Charset.md)
  * [Cnh](Cnh.md)
  * [Cnpj](Cnpj.md)
  * [Cntrl](Cntrl.md)
  * [Consonant](Consonant.md)
  * [Contains](Contains.md)
  * [Countable](Countable.md)
  * [CountryCode](CountryCode.md)
  * [Cpf](Cpf.md)
  * [CreditCard](CreditCard.md)
  * [Date](Date.md)
  * [Digit](Digit.md)
  * [Directory](Directory.md)
  * [Domain](Domain.md)
  * [Each](Each.md)
  * [Email](Email.md)
  * [EndsWith](EndsWith.md)
  * [Equals](Equals.md)
  * [Even](Even.md)
  * [Executable](Executable.md)
  * [Exists](Exists.md)
  * [Extension](Extension.md)
  * [Factor](Factor.md)
  * [FalseVal](FalseVal.md)
  * [Fibonacci](Fibonacci.md)
  * [File](File.md)
  * [FilterVar](FilterVar.md)
  * [Finite](Finite.md)
  * [FloatVal](FloatVal.md)
  * [FloatType](FloatType.md)
  * [Graph](Graph.md)
  * [HexRgbColor](HexRgbColor.md)
  * [Identical](Identical.md)
  * [IdentityCard](IdentityCard.md)
  * [Image](Image.md)
  * [Imei](Imei.md)
  * [In](In.md)
  * [Infinite](Infinite.md)
  * [Instance](Instance.md)
  * [IntVal](IntVal.md)
  * [IntType](IntType.md)
  * [Ip](Ip.md)
  * [IterableType](IterableType.md)
  * [Json](Json.md)
  * [Key](Key.md)
  * [KeyNested](KeyNested.md)
  * [KeySet](KeySet.md)
  * [KeyValue](KeyValue.md)
  * [LanguageCode](LanguageCode.md)
  * [LeapDate](LeapDate.md)
  * [LeapYear](LeapYear.md)
  * [Length](Length.md)
  * [Lowercase](Lowercase.md)
  * [MacAddress](MacAddress.md)
  * [Max](Max.md)
  * [Mimetype](Mimetype.md)
  * [Min](Min.md)
  * [MinimumAge](MinimumAge.md)
  * [Multiple](Multiple.md)
  * [Negative](Negative.md)
  * [NfeAccessKey](NfeAccessKey.md)
  * [No](No.md)
  * [NoWhitespace](NoWhitespace.md)
  * [NoneOf](NoneOf.md)
  * [Not](Not.md)
  * [NotBlank](NotBlank.md)
  * [NotEmpty](NotEmpty.md)
  * [NotOptional](NotOptional.md)
  * [NullType](NullType.md)
  * [Numeric](Numeric.md)
  * [ObjectType](ObjectType.md)
  * [Odd](Odd.md)
  * [OneOf](OneOf.md)
  * [Optional](Optional.md)
  * [PerfectSquare](PerfectSquare.md)
  * [Pesel](Pesel.md)
  * [Phone](Phone.md)
  * [PhpLabel](PhpLabel.md)
  * [Positive](Positive.md)
  * [PostalCode](PostalCode.md)
  * [PrimeNumber](PrimeNumber.md)
  * [Prnt](Prnt.md)
  * [Punct](Punct.md)
  * [Readable](Readable.md)
  * [Regex](Regex.md)
  * [ResourceType](ResourceType.md)
  * [Roman](Roman.md)
  * [ScalarVal](ScalarVal.md)
  * [Sf](Sf.md)
  * [Size](Size.md)
  * [Slug](Slug.md)
  * [Space](Space.md)
  * [StartsWith](StartsWith.md)
  * [StringType](StringType.md)
  * [SubdivisionCode](SubdivisionCode.md)
  * [SymbolicLink](SymbolicLink.md)
  * [Tld](Tld.md)
  * [TrueVal](TrueVal.md)
  * [Type](Type.md)
  * [Uploaded](Uploaded.md)
  * [Uppercase](Uppercase.md)
  * [Url](Url.md)
  * [Version](Version.md)
  * [VideoUrl](VideoUrl.md)
  * [Vowel](Vowel.md)
  * [When](When.md)
  * [Writable](Writable.md)
  * [Xdigit](Xdigit.md)
  * [Yes](Yes.md)
  * [Zend](Zend.md)

***
See also:

- [Contributing](../CONTRIBUTING.md)
- [Feature Guide](README.md)
- [Installation](INSTALL.md)
- [License](../LICENSE.md)
- [Changelog](../CHANGELOG.md)
