<?php

/**
 * Defines the routes for APIs
 *
 * @author Congyu Fan
 * @since Apr 1, 2017
 */


use \Azi\Input;
use \App\Misc\API\APIResponseGenerator;
use \App\Controllers\API\TeamAPILocationController;
use \App\Controllers\API\TeamAPIHuntController;
use \App\Controllers\API\TeamAPIScoreboardController;
use \App\Controllers\API\TeamAPIQuizController;
use App\Controllers\API\TeamAPITeamController;


Router::post(
    'api/team/location',
    function () {
        $action = Input::request('action');

        switch ($action) {
            case 'retrieve':
                return ntAPIInvokeControllerMethod(TeamAPILocationController::class, 'retrieve');

            case 'update':
                return ntAPIInvokeControllerMethod(TeamAPILocationController::class, 'update');

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    ntGetStringLiteral('INVALID_ACTION')
                );
        }
    }
);

Router::post(
    'api/team/hunt',
    function() {
        $action = Input::request('action');

        switch ($action) {
            case 'retrieve':
                return ntAPIInvokeControllerMethod(TeamAPIHuntController::class, 'retrieve');

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    ntGetStringLiteral('INVALID_ACTION')
                );
        }
    }
);

Router::post(
    'api/team/scoreboard',
    function() {
        $target = Input::request('target');

        switch ($target) {
            case 'live':
                return ntAPIInvokeControllerMethod(TeamAPIScoreboardController::class, 'liveScore');

            case 'final':
                return ntAPIInvokeControllerMethod(TeamAPIScoreboardController::class, 'finalScore');

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    'Invalid target'
                );
        }
    }
);

Router::post(
    'api/team/quiz',
    function () {
        $action = Input::request('action');

        switch ($action) {
            case 'retrieve':
                return ntAPIInvokeControllerMethod(
                    TeamAPIQuizController::class,
                    'retrieve'
                );

            case 'update':
                return ntAPIInvokeControllerMethod(
                    TeamAPIQuizController::class,
                    'update'
                );

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    ntGetStringLiteral('INVALID_ACTION')
                );
        }
    }
);


Router::post(
    'api/team/team',
    function () {
        $action = Input::request('action');

        switch ($action) {
            case 'update':
                return ntAPIInvokeControllerMethod(
                    TeamAPITeamController::class,
                    'update'
                );

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    ntGetStringLiteral('INVALID_ACTION')
                );
        }
    }
);