<?php

use \App\Controllers\API\StaffLocManageController;
use \App\Controllers\API\StaffHuntManageController;
use \App\Controllers\API\StaffLocTemplateController;
use \App\Controllers\API\StaffQuizQuestionController;
use \App\Controllers\API\StaffQuizOptionController;
use \Azi\Input;
use \App\Misc\API\APIResponseGenerator;

Router::post(
    '/api/staff/location',
    function () {
        $action = Input::request('action');
        $errMsg = null;
        if (!(new \App\Misc\Validation\StaffLocationManageValidate())->validate($action, $errMsg)) {
            return APIResponseGenerator::genJsonErrorMsg(
                \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                $errMsg
            );
        }

        switch ($action) {
            case 'create':
                return ntAPIInvokeControllerMethod(
                    StaffLocManageController::class,
                    'createLoc'
                );

            case 'update':
                return ntAPIInvokeControllerMethod(
                    StaffLocManageController::class,
                    'updateLocation'
                );

            case 'delete':
                return ntAPIInvokeControllerMethod(
                    StaffLocManageController::class,
                    'removeLoc'
                );

            case 'retrieve':
                return ntAPIInvokeControllerMethod(
                    StaffLocManageController::class,
                    'queryLocForHunt'
                );

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    ntGetStringLiteral('INVALID_ACTION')
                );
        }

    }
);

Router::post(
    '/api/staff/hunt',
    function () {
        $action = Input::request('action');
        $errMsg = null;
        if (!(new \App\Misc\Validation\StaffHuntManageValidate())->validate($action, $errMsg)) {
            return APIResponseGenerator::genJsonErrorMsg(
                \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                $errMsg
            );
        }

        switch ($action) {
            case 'create':
                return ntAPIInvokeControllerMethod(
                    StaffHuntManageController::class,
                    'createHunt'
                );

            case 'start':
                return ntAPIInvokeControllerMethod(
                    StaffHuntManageController::class,
                    'startHunt'
                );

            case 'delete':
                return ntAPIInvokeControllerMethod(
                    StaffHuntManageController::class,
                    'removeHunt'
                );

            case 'retrieve':
                return ntAPIInvokeControllerMethod(
                    StaffHuntManageController::class,
                    'getHunts'
                );

            case 'retrieve_one':
                return ntAPIInvokeControllerMethod(
                    StaffHuntManageController::class,
                    'getHuntInfo'
                );

            case 'retrieve_teams':
                return ntAPIInvokeControllerMethod(
                    StaffHuntManageController::class,
                    'getHuntTeams'
                );

            case 'reset':
                return ntAPIInvokeControllerMethod(
                    StaffHuntManageController::class,
                    'resetHunt'
                );

            case 'dist_email':
                return ntAPIInvokeControllerMethod(
                    StaffHuntManageController::class,
                    'distPWDByEmail'
                );

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    ntGetStringLiteral('INVALID_ACTION')
                );
        }
    }
);


Router::post(
    '/api/staff/template',
    function () {
        $errMsg = null;
        $action = Input::request('action');
        if (!(new \App\Misc\Validation\StaffLocTemplateValidate())->validate($action, $errMsg)) {
            return APIResponseGenerator::genJsonErrorMsg(
                \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                $errMsg
            );
        }

        switch ($action) {
            case 'create':
                return ntAPIInvokeControllerMethod(
                    StaffLocTemplateController::class,
                    'createTemplate'
                );

            case 'update':
                return ntAPIInvokeControllerMethod(
                    StaffLocTemplateController::class,
                    'updateTemplate'
                );

            case 'delete':
                return ntAPIInvokeControllerMethod(
                    StaffLocTemplateController::class,
                    'removeTemplate'
                );

            case 'retrieve':
                return ntAPIInvokeControllerMethod(
                    StaffLocTemplateController::class,
                    'getTemplates'
                );

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    ntGetStringLiteral('INVALID_ACTION')
                );
        }
    }
);


Router::post(
    '/api/staff/quiz',
    function () {
        $action = Input::request('action');

        $errMsg = null;
        if (!(new \App\Misc\Validation\StaffQuizQuestionValidate())->validate($action, $errMsg)) {
            return APIResponseGenerator::genJsonErrorMsg(
                \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                $errMsg
            );
        }

        switch ($action) {
            case 'retrieve':
                return ntAPIInvokeControllerMethod(
                    StaffQuizQuestionController::class,
                    'retrieve'
                );

            case 'update':
                return ntAPIInvokeControllerMethod(
                    StaffQuizQuestionController::class,
                    'update'
                );

            case 'create':
                return ntAPIInvokeControllerMethod(
                    StaffQuizQuestionController::class,
                    'create'
                );

            case 'delete':
                return ntAPIInvokeControllerMethod(
                    StaffQuizQuestionController::class,
                    'delete'
                );

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    ntGetStringLiteral('INVALID_ACTION')
                );
        }
    }
);

Router::post(
    '/api/staff/quiz_option',
    function () {
        $action = Input::request('action');

        $errMsg = null;
        if (!(new \App\Misc\Validation\StaffQuizOptionValidate($action, $errMsg))->validate($action, $errMsg)) {
            return APIResponseGenerator::genJsonErrorMsg(
                \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                $errMsg
            );
        }

        switch ($action) {
            case 'create':
                return ntAPIInvokeControllerMethod(
                    StaffQuizOptionController::class,
                    'create'
                );

            case 'delete':
                return ntAPIInvokeControllerMethod(
                    StaffQuizOptionController::class,
                    'delete'
                );

            case 'set_correct':
                return ntAPIInvokeControllerMethod(
                    StaffQuizOptionController::class,
                    'setCorrect'
                );

            default:
                return APIResponseGenerator::genJsonErrorMsg(
                    \Kayex\HttpCodes::HTTP_BAD_REQUEST,
                    ntGetStringLiteral('INVALID_ACTION')
                );
        }
    }
);