<?php


Router::any(
    '/auth/{action:a}',
    function($action) {
        switch ($action) {
            case 'login':
                return ntInvokeControllerMethod(
                    \App\Controllers\Site\StaffAuthController::class,
                    "login"
                );

            case 'logout':
                return ntInvokeControllerMethod(
                    \App\Controllers\Site\StaffAuthController::class,
                    "logout"
                );
            default:
                return \App\Misc\API\APIResponseGenerator::genJsonErrorMsg(\Kayex\HttpCodes::HTTP_BAD_REQUEST, ntGetStringLiteral('INVALID_ACTION'));
        }
    }
);

Router::any(
    '/',
    function() {
        return ntRenderView('Pages/Home');
    }
);

Router::any(
    '/{target:a}',
    function($target) {
        switch ($target) {
            case 'download': {
                $download = \Apfelbox\FileDownload\FileDownload::createFromFilePath(NUTTY_PUBLIC_DIR.'/assets/downloads/Nutty.apk');
                $download->sendDownload('Nutty.apk');
                return null;
            }
            case 'getnutty': {
                return ntRenderView('Pages/GetNutty');
            }
            case 'team': {
                return ntRenderView('Pages/Team');
            }
            case 'sitemanual': {
                $download = \Apfelbox\FileDownload\FileDownload::createFromFilePath(NUTTY_PUBLIC_DIR.'/assets/downloads/Site.pdf');
                $download->sendDownload('Website.pdf');
                return null;
            }
            case 'appmanual': {
                $download = \Apfelbox\FileDownload\FileDownload::createFromFilePath(NUTTY_PUBLIC_DIR.'/assets/downloads/App.pdf');
                $download->sendDownload('App.pdf');
                return null;
            }
        }
    }
);