<?php
/**
 * Common router settings.
 *
 * @author Congyu Fan
 * @since Mar 21, 2017
 */

use App\Misc\API\APIResponseGenerator;
use App\Misc\Auth\AuthInterface;
use App\Misc\Auth\TeamAuth;
use App\Misc\Auth\StaffAuth;



Router::filter(
    'BindTeamAuthInterface',
    function() {
        //Bind AuthInterface with APIAuth
        if (!App::bindInterface(AuthInterface::class, TeamAuth::class)) {
            echo APIResponseGenerator::genJsonErrorMsg();
            return false;
        }
    }
);

Router::filter(
    'BindStaffAuthInterface',
    function() {
        //Bind AuthInterface with APIAuth
        if (!App::bindInterface(AuthInterface::class, StaffAuth::class)) {
            echo APIResponseGenerator::genJsonErrorMsg();
            return false;
        }

        return null;
    }
);


/**
 * A filter for the authorization of the api users.
 */
Router::filter(
    'Auth',
    function () {
        //If the password is invalid.
        if (!Auth::isAuthenticated()) {
            echo APIResponseGenerator::genJsonErrorMsg(\Kayex\HttpCodes::HTTP_UNAUTHORIZED, 'Unauthorized request');
            return false;
        }
    }
);

Router::filter(
    'StaffPageAuth',
    function () {
        //If the password is invalid.
        if (!Auth::isAuthenticated()) {
            App::make(\OhHttp\Response::class)->redirect(ntGetRootDir().'/auth/login');
            return false;
        }
    }
);

/**
 * To load team api routes.
 */
Router::group(['before' => ['BindTeamAuthInterface', 'Auth']], function(){
    ntGetConfigFile(NUTTY_ROUTE_DIR.'/TeamAPI.php');
});

/**
 * To load staff api routes.
 */
Router::group(['before' => ['BindStaffAuthInterface', 'Auth']], function(){
    ntGetConfigFile(NUTTY_ROUTE_DIR.'/StaffAPI.php');
});

/**
 * To load public routes.
 */
Router::group(['before' => ['BindStaffAuthInterface']], function(){
    ntGetConfigFile(NUTTY_ROUTE_DIR.'/Public.php');
});

/**
 * To load page routes for staff.
 */
Router::group(['before' => ['BindStaffAuthInterface', 'StaffPageAuth']], function(){
    ntGetConfigFile(NUTTY_ROUTE_DIR.'/StaffPage.php');
});