<?php
/**
 * A trait which can let an object register itself with the service container.
 *
 * @author Congyu Fan
 * @since Apr 1, 2017
 */


namespace Nutty\Utility;

/**
 * Class SelfRegister
 * @package Nutty\Utility
 */
trait SelfRegister
{
    /**
     * SelfRegister constructor. This cannot be overridden.
     */
    public final function __construct() {
        //bind the object itself with the container.
        App::bindInstance(get_class(), $this);
        //call the init method.
        $this->init();
    }

    /**
     * Can be overridden to replace the constructor.
     */
    public function init() {}
}