<?php
/**
 * Service provider for Klein Router.
 * This file is written based on https://github.com/klein/klein.php/wiki/Sub-Directory-Installation
 *
 * @author Congyu Fan
 * @since Mar 21, 2017
 */

namespace Nutty\Providers;

use Nutty\Core\IoC\AbstractServiceProvider;
use Phroute\Phroute\RouteCollector;

/**
 * Class RouterProvider
 * @package Nutty\Providers
 */
class RouterProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function register()
    {
        //bind router with the container.
        $this->container->bindInstance('router', new RouteCollector());
    }
}