<?php
/**
 * Service provider for Response and Request object
 *
 * @author Congyu Fan
 * @since Apr 1, 2017
 */

namespace Nutty\Providers;


use Nutty\Core\IoC\AbstractServiceProvider;
use OhHttp\Request;
use OhHttp\Response;
use \Bistro\Session\Native;
use Bistro\Session\Session;


/**
 * Class HttpProvider
 * @package Nutty\Providers
 */
class HttpProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function register() {
        $this->container->bindSingleton(
            Request::class,
            function() {
                return new Request();
            }
            );

        $this->container->bindSingleton(
            Response::class,
            function() {
                return new Response();
            }
        );


        $this->container->bindSingleton(
            Session::class,
            function() {
                $ttl = ntLoadGlobalConfig('session_alive_time');
                $session = new Native(
                    null,
                    [
                        'cookie_lifetime' => $ttl,
                        'gc_maxlifetime' => $ttl
                    ]
                );
                return $session;
            }
        );
    }
}