<?php

/**
 * Bind Container itself with Container
 *
 * @author Congyu Fan
 * @since Mar 21, 2017
 */

namespace Nutty\Providers;

use Nutty\Core\IoC\AbstractServiceProvider;
use Nutty\Core\IoC\Container;

/**
 * Class ContainerProvider
 * @package Nutty\Providers
 */
class ContainerProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function register()
    {
        $this->container->bindInstance('app', $this->container);
        $this->container->bindInstance(Container::class, $this->container);
    }
}