<?php
/**
 * To load the entire framework.
 *
 * @author Congyu Fan
 */

namespace Nutty;

use Nutty\Core\IoC\Container;
use Nutty\Core\IoC\ProviderLoader;
use Phroute\Phroute\Dispatcher;

class NuttyFramework
{
    /**
     * Initialise the whole framework.
     */
    public function init()
    {
        define('NUTTY_ROOT_DIR', __DIR__.'/..');    //DIR to root directory
        define('NUTTY_APP_DIR', NUTTY_ROOT_DIR.'/app');     //DIR to app folder
        define('NUTTY_CONFIG_DIR', NUTTY_ROOT_DIR.'/config');   //DIR to config folder
        define('NUTTY_FRAMEWORK_DIR', NUTTY_ROOT_DIR.'/nutty'); //DIR to nutty folder
        define('NUTTY_PUBLIC_DIR', NUTTY_ROOT_DIR.'/public');   //DIR to public folder
        define('NUTTY_ROUTE_DIR', NUTTY_ROOT_DIR.'/route');     //DIR to route folder
        define('NUTTY_MODEL_DIR', NUTTY_APP_DIR.'/Models');     //DIR to app/Models
        define('NUTTY_VIEW_DIR', NUTTY_APP_DIR.'/Views');   //DIR to app/Views
        define('NUTTY_CONTROLLER_DIR', NUTTY_APP_DIR.'/Controllers');   //DIR to app/Controllers

        // Load auto-generated composer autoload module
        include (NUTTY_ROOT_DIR.'/vendor/autoload.php');
        // Load auto-generated propel database configurations
        ntGetConfigFile(NUTTY_ROOT_DIR.'/database/generated-conf/config.php');

        /*
         * Modify REQUEST_URI, for the subdirectory installation of the router.
         * Copied from Klein wiki.
         * https://github.com/klein/klein.php/wiki/Sub-Directory-Installation
         */
        $base  = dirname($_SERVER['PHP_SELF']);

        if(ltrim($base, '/')){
            $_SERVER['REQUEST_URI'] = substr($_SERVER['REQUEST_URI'], strlen($base));
        }

        // Initialise DI container
        Container::getInstance();
        //Load provider list
        ProviderLoader::loadProviders(NUTTY_CONFIG_DIR.'/app.php');
        ntGetConfigFile(NUTTY_ROUTE_DIR.'/Entry.php');
    }

    /**
     * Dispatch request to routes defined.
     */
    public function dispatch()
    {
        /*
         * Copied from phroute doc
         * https://github.com/mrjgreen/phroute
         */
        $dispatcher = new Dispatcher(Router::getData());
        $response = $dispatcher->dispatch($_SERVER['REQUEST_METHOD'], parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
        echo $response;
    }
}

