<?php
/**
 * Common helper functions
 *
 * @author Congyu Fan
 * @since Mar 17, 2017
 */

/**
 * Load an array from a configuration file.
 *
 * @param string $filename The name of the configuration file
 * @return mixed The returned data
 */
if (!function_exists('ntGetConfigFile')) {
    function ntGetConfigFile($filename)
    {
        return include($filename);
    }
}


if (!function_exists('ntLoadGlobalConfig')) {
    /**
     * Get global configuration by a given key.
     *
     * @param string $key
     * @return mixed
     */
    function ntLoadGlobalConfig($key)
    {
        static $config = null;

        if (!$config) {
            $config = ntGetConfigFile(NUTTY_CONFIG_DIR.'/global_config.php');
        }

        return $config[$key];
    }
}


if (!function_exists('ntInvokeControllerMethod')) {
    /**
     * Invoke a controller method.
     * makeAndExecute() method of Container class will be called
     *
     * @param string $controllerName The full name of a controller class.
     * @param string $methodName The name of the controller method.
     * @param array $methodArgs Argument list in "argName" => "value" pair
     * @return mixed    the return value from the controller method.
     * @throws ErrorException If $controllerName doesn't extend AbstractController
     */
    function ntInvokeControllerMethod($controllerName, $methodName, $methodArgs = [])
    {
        if (!is_subclass_of($controllerName, \Nutty\Controller\AbstractController::class, true)) {
            throw new \ErrorException("$controllerName should extend \\Nutty\\Controller\\AbstractController");
        }

        return App::makeAndExecute($controllerName, $methodName, $methodArgs);
    }
}

if (!function_exists('ntGetRequestInput')) {
    /**
     * Get request string by a given key.
     *
     * @param $key
     * @return string An empty string if no data of that key can be found.
     */
    function ntGetRequestInput($key)
    {
        return \Azi\Input::exists($key) ?
            \Azi\Input::request($key) :
            '';
    }
}

if (!function_exists('ntGetStringLiteral')) {
    /**
     * Get a string literal by a given key.
     *
     * @param string $key
     * @return string If no string was found, return $key itself.
     */
    function ntGetStringLiteral($key)
    {
        static $stringLiteral = null;
        if (!$stringLiteral) {
            $stringLiteral = ntGetConfigFile(NUTTY_CONFIG_DIR.'/string_literal.php');
        }
        return array_key_exists($key, $stringLiteral) ? $stringLiteral[$key] : $key;
    }
}

if (!function_exists('ntRenderView')) {
    function ntRenderView($name, $args = [])
    {
        $templates = new League\Plates\Engine(NUTTY_VIEW_DIR);
        return $templates->render($name, $args);
    }
}

if (!function_exists('ntGetRootURI')) {
    /**
     * Get the uri to the public folder.
     *
     * @return string
     */
    function ntGetRootDir() {
        //Use PHP_SELF because all requests are handled by index.php
        return dirname($_SERVER['PHP_SELF']);
    }
}