<?php
/**
 * To load Service Providers.
 * Inspired by Laravel framework.
 *
 * @author Congyu Fan
 * @since Apr 1, 2017
 */

namespace Nutty\Core\IoC;


class ProviderLoader
{
    /**
     * Load providers from the configuration file.
     *
     * @param string $file The configuration file
     * @return void
     */
    public static function loadProviders($file = '')
    {
        $providerList = ntGetConfigFile($file)['providers'];

        foreach ($providerList as $provider) {
            //Make sure each given provider extends AbstractServiceProvider
            if (!is_subclass_of($provider, AbstractServiceProvider::class)) {
                throw new \InvalidArgumentException("$provider is not a service provider which extends AbstractServiceProvider");
            }

            //execute register method.
            Container::getInstance()->makeAndExecute($provider, 'register');
        }
    }
}