<?php

/**
 * Abstract class of Service providers. Inspired by Laravel Framework.
 *
 * @author Congyu Fan
 * @since March 16, 2017
 */

namespace Nutty\Core\IoC;

/**
 * Class AbstractServiceProvider
 * @package Nutty\Core\IoC
 */
abstract class AbstractServiceProvider
{
    /**
     * @var Container $container Instance of the container.
     */
    protected $container;

    public final function __construct()
    {
        $this->container = Container::getInstance();
    }


    public abstract function register();
}